/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.algorithm.multiobjective;

import java.util.Arrays;
import java.util.Comparator;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.catalogue.common.evaluation.Evaluation;
import org.uma.jmetal.component.catalogue.common.evaluation.impl.SequentialEvaluation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.SolutionsCreation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.impl.RandomSolutionsCreation;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.component.catalogue.ea.replacement.impl.RankingAndDensityEstimatorReplacement;
import org.uma.jmetal.component.catalogue.ea.selection.Selection;
import org.uma.jmetal.component.catalogue.ea.selection.impl.NaryTournamentSelection;
import org.uma.jmetal.component.catalogue.ea.variation.Variation;
import org.uma.jmetal.component.catalogue.ea.variation.impl.CrossoverAndMutationVariation;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.comparator.MultiComparator;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.ranking.Ranking;

public class RDSMOEABuilder<S extends Solution<?>> {
    private String name = "MOEA";
    private Ranking<S> ranking;
    private DensityEstimator<S> densityEstimator;
    private Evaluation<S> evaluation;
    private SolutionsCreation<S> createInitialPopulation;
    private Termination termination;
    private Selection<S> selection;
    private Variation<S> variation;
    private Replacement<S> replacement;

    public RDSMOEABuilder(Problem<S> problem, int populationSize, int offspringPopulationSize, CrossoverOperator<S> crossover, MutationOperator<S> mutation, Ranking<S> ranking, DensityEstimator<S> densityEstimator, Replacement.RemovalPolicy removalPolicy) {
        this.createInitialPopulation = new RandomSolutionsCreation<S>(problem, populationSize);
        this.replacement = new RankingAndDensityEstimatorReplacement<S>(ranking, densityEstimator, removalPolicy);
        this.variation = new CrossoverAndMutationVariation<S>(offspringPopulationSize, crossover, mutation);
        int tournamentSize = 2;
        Comparator[] comparatorArray = new Comparator[2];
        comparatorArray[0] = Comparator.comparing(arg_0 -> ranking.getRank(arg_0));
        comparatorArray[1] = Comparator.comparing(arg_0 -> densityEstimator.value(arg_0)).reversed();
        this.selection = new NaryTournamentSelection(tournamentSize, this.variation.getMatingPoolSize(), new MultiComparator(Arrays.asList(comparatorArray)));
        this.termination = new TerminationByEvaluations(25000);
        this.evaluation = new SequentialEvaluation<S>(problem);
    }

    public RDSMOEABuilder<S> setTermination(Termination termination) {
        this.termination = termination;
        return this;
    }

    public RDSMOEABuilder<S> setRanking(Ranking<S> ranking) {
        this.ranking = ranking;
        this.replacement = new RankingAndDensityEstimatorReplacement<S>(ranking, this.densityEstimator, Replacement.RemovalPolicy.ONE_SHOT);
        return this;
    }

    public RDSMOEABuilder<S> setEvaluation(Evaluation<S> evaluation) {
        this.evaluation = evaluation;
        return this;
    }

    public RDSMOEABuilder<S> setCreateInitialPopulation(SolutionsCreation<S> solutionsCreation) {
        this.createInitialPopulation = solutionsCreation;
        return this;
    }

    public EvolutionaryAlgorithm<S> build() {
        return new EvolutionaryAlgorithm<S>(this.name, this.createInitialPopulation, this.evaluation, this.termination, this.selection, this.variation, this.replacement);
    }
}

