/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.algorithm.multiobjective;

import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.catalogue.common.evaluation.Evaluation;
import org.uma.jmetal.component.catalogue.common.evaluation.impl.SequentialEvaluation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.SolutionsCreation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.impl.RandomSolutionsCreation;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.component.catalogue.ea.replacement.impl.SMSEMOAReplacement;
import org.uma.jmetal.component.catalogue.ea.selection.Selection;
import org.uma.jmetal.component.catalogue.ea.selection.impl.RandomSelection;
import org.uma.jmetal.component.catalogue.ea.variation.Variation;
import org.uma.jmetal.component.catalogue.ea.variation.impl.CrossoverAndMutationVariation;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.util.ranking.Ranking;
import org.uma.jmetal.util.ranking.impl.FastNonDominatedSortRanking;

public class SMSEMOABuilder<S extends Solution<?>> {
    private String name = "SMS-EMOA";
    private Ranking<S> ranking = new FastNonDominatedSortRanking();
    private Evaluation<S> evaluation;
    private SolutionsCreation<S> createInitialPopulation;
    private Termination termination;
    private Selection<S> selection;
    private Variation<S> variation;
    private Replacement<S> replacement;

    public SMSEMOABuilder(Problem<S> problem, int populationSize, CrossoverOperator<S> crossover, MutationOperator<S> mutation) {
        this.createInitialPopulation = new RandomSolutionsCreation<S>(problem, populationSize);
        PISAHypervolume hypervolume = new PISAHypervolume();
        this.replacement = new SMSEMOAReplacement<S>(this.ranking, hypervolume);
        this.variation = new CrossoverAndMutationVariation<S>(1, crossover, mutation);
        this.selection = new RandomSelection(this.variation.getMatingPoolSize());
        this.termination = new TerminationByEvaluations(25000);
        this.evaluation = new SequentialEvaluation<S>(problem);
    }

    public SMSEMOABuilder<S> setTermination(Termination termination) {
        this.termination = termination;
        return this;
    }

    public SMSEMOABuilder<S> setRanking(Ranking<S> ranking) {
        this.ranking = ranking;
        PISAHypervolume hypervolume = new PISAHypervolume();
        this.replacement = new SMSEMOAReplacement<S>(ranking, hypervolume);
        return this;
    }

    public SMSEMOABuilder<S> setEvaluation(Evaluation<S> evaluation) {
        this.evaluation = evaluation;
        return this;
    }

    public EvolutionaryAlgorithm<S> build() {
        return new EvolutionaryAlgorithm<S>(this.name, this.createInitialPopulation, this.evaluation, this.termination, this.selection, this.variation, this.replacement);
    }
}

