/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.common.evaluation.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.common.evaluation.Evaluation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;

public class MultiThreadedEvaluation<S extends Solution<?>>
implements Evaluation<S> {
    private int computedEvaluations;
    private final Problem<S> problem;
    private final int numberOfThreads;

    public MultiThreadedEvaluation(int numberOfThreads, Problem<S> problem) {
        Check.that((numberOfThreads >= 0 ? 1 : 0) != 0, (String)("The number of threads is a negative value: " + numberOfThreads));
        Check.notNull(problem);
        if (numberOfThreads == 0) {
            numberOfThreads = Runtime.getRuntime().availableProcessors();
        }
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", "" + numberOfThreads);
        this.numberOfThreads = numberOfThreads;
        this.problem = problem;
        this.computedEvaluations = 0;
    }

    @Override
    public List<S> evaluate(List<S> solutionList) {
        Check.notNull(solutionList);
        solutionList.parallelStream().forEach(arg_0 -> this.problem.evaluate(arg_0));
        this.computedEvaluations = solutionList.size();
        return solutionList;
    }

    @Override
    public int computedEvaluations() {
        return this.computedEvaluations;
    }

    public int numberOfThreads() {
        return this.numberOfThreads;
    }

    @Override
    public Problem<S> problem() {
        return this.problem;
    }
}

