/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.common.solutionscreation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.component.catalogue.common.solutionscreation.SolutionsCreation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.bounds.Bounds;

public class LatinHypercubeSamplingSolutionsCreation
implements SolutionsCreation<DoubleSolution> {
    private final int numberOfSolutionsToCreate;
    private final DoubleProblem problem;

    public LatinHypercubeSamplingSolutionsCreation(DoubleProblem problem, int numberOfSolutionsToCreate) {
        this.problem = problem;
        this.numberOfSolutionsToCreate = numberOfSolutionsToCreate;
    }

    @Override
    public List<DoubleSolution> create() {
        int[][] latinHypercube = new int[this.numberOfSolutionsToCreate][this.problem.numberOfVariables()];
        for (int dim = 0; dim < this.problem.numberOfVariables(); ++dim) {
            List<Integer> permutation = this.getPermutation(this.numberOfSolutionsToCreate);
            for (int v = 0; v < this.numberOfSolutionsToCreate; ++v) {
                latinHypercube[v][dim] = permutation.get(v);
            }
        }
        ArrayList<DoubleSolution> solutionList = new ArrayList<DoubleSolution>(this.numberOfSolutionsToCreate);
        for (int i = 0; i < this.numberOfSolutionsToCreate; ++i) {
            DefaultDoubleSolution newSolution = new DefaultDoubleSolution(this.problem.variableBounds(), this.problem.numberOfObjectives(), this.problem.numberOfConstraints());
            for (int j = 0; j < this.problem.numberOfVariables(); ++j) {
                Bounds bounds = (Bounds)this.problem.variableBounds().get(j);
                newSolution.variables().set(j, NormalizeUtils.normalize((double)latinHypercube[i][j], (double)((Double)bounds.getLowerBound()), (double)((Double)bounds.getUpperBound()), (double)0.0, (double)this.numberOfSolutionsToCreate));
            }
            solutionList.add((DoubleSolution)newSolution);
        }
        return solutionList;
    }

    private List<Integer> getPermutation(int permutationLength) {
        ArrayList<Integer> randomSequence = new ArrayList<Integer>(permutationLength);
        for (int j = 0; j < permutationLength; ++j) {
            randomSequence.add(j);
        }
        Collections.shuffle(randomSequence);
        return randomSequence;
    }
}

