/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.common.solutionscreation.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.component.catalogue.common.solutionscreation.SolutionsCreation;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.solution.doublesolution.impl.DefaultDoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class ScatterSearchSolutionsCreation
implements SolutionsCreation<DoubleSolution> {
    private final int numberOfSolutionsToCreate;
    private final DoubleProblem problem;
    private final int numberOfSubRanges;
    protected int[] sumOfFrequencyValues;
    protected int[] sumOfReverseFrequencyValues;
    protected int[][] frequency;
    protected int[][] reverseFrequency;

    public ScatterSearchSolutionsCreation(DoubleProblem problem, int numberOfSolutionsToCreate, int numberOfSubRanges) {
        this.problem = problem;
        this.numberOfSolutionsToCreate = numberOfSolutionsToCreate;
        this.numberOfSubRanges = numberOfSubRanges;
        this.sumOfFrequencyValues = new int[problem.numberOfVariables()];
        this.sumOfReverseFrequencyValues = new int[problem.numberOfVariables()];
        this.frequency = new int[numberOfSubRanges][problem.numberOfVariables()];
        this.reverseFrequency = new int[numberOfSubRanges][problem.numberOfVariables()];
    }

    @Override
    public List<DoubleSolution> create() {
        ArrayList<DoubleSolution> solutionList = new ArrayList<DoubleSolution>(this.numberOfSolutionsToCreate);
        for (int i = 0; i < this.numberOfSolutionsToCreate; ++i) {
            List<Double> variables = this.generateVariables();
            DefaultDoubleSolution newSolution = new DefaultDoubleSolution(this.problem.variableBounds(), this.problem.numberOfObjectives(), this.problem.numberOfConstraints());
            for (int j = 0; j < this.problem.numberOfVariables(); ++j) {
                newSolution.variables().set(j, variables.get(j));
            }
            solutionList.add((DoubleSolution)newSolution);
        }
        return solutionList;
    }

    private List<Double> generateVariables() {
        ArrayList<Double> vars = new ArrayList<Double>(this.problem.numberOfVariables());
        for (int i = 0; i < this.problem.numberOfVariables(); ++i) {
            int range;
            this.sumOfReverseFrequencyValues[i] = 0;
            for (int j = 0; j < this.numberOfSubRanges; ++j) {
                this.reverseFrequency[j][i] = this.sumOfFrequencyValues[i] - this.frequency[j][i];
                int n = i;
                this.sumOfReverseFrequencyValues[n] = this.sumOfReverseFrequencyValues[n] + this.reverseFrequency[j][i];
            }
            if (this.sumOfReverseFrequencyValues[i] == 0) {
                range = JMetalRandom.getInstance().nextInt(0, this.numberOfSubRanges - 1);
            } else {
                double value = JMetalRandom.getInstance().nextInt(0, this.sumOfReverseFrequencyValues[i] - 1);
                range = 0;
                while (value > (double)this.reverseFrequency[range][i]) {
                    value -= (double)this.reverseFrequency[range][i];
                    ++range;
                }
            }
            int[] nArray = this.frequency[range];
            int n = i;
            nArray[n] = nArray[n] + 1;
            int n2 = i;
            this.sumOfFrequencyValues[n2] = this.sumOfFrequencyValues[n2] + 1;
            Bounds bounds = (Bounds)this.problem.variableBounds().get(i);
            Double lowerBound = (Double)bounds.getLowerBound();
            Double upperBound = (Double)bounds.getUpperBound();
            double low = lowerBound + (double)range * (upperBound - lowerBound) / (double)this.numberOfSubRanges;
            double high = low + (upperBound - lowerBound) / (double)this.numberOfSubRanges;
            vars.add(i, JMetalRandom.getInstance().nextDouble(low, high));
        }
        return vars;
    }
}

