/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.common.termination.impl;

import java.util.Map;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.util.errorchecking.Check;

public class TerminationByComputingTime
implements Termination {
    private final long maxComputingTime;
    private int evaluations;

    public TerminationByComputingTime(long maxComputingTime) {
        this.maxComputingTime = maxComputingTime;
    }

    @Override
    public boolean isMet(Map<String, Object> algorithmStatusData) {
        Check.notNull((Object)algorithmStatusData.get("COMPUTING_TIME"));
        Check.notNull((Object)algorithmStatusData.get("EVALUATIONS"));
        long currentComputingTime = (Long)algorithmStatusData.get("COMPUTING_TIME");
        this.evaluations = (Integer)algorithmStatusData.get("EVALUATIONS");
        return currentComputingTime >= this.maxComputingTime;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public long getMaxComputingTime() {
        return this.maxComputingTime;
    }
}

