/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.common.termination.impl;

import java.util.Map;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.util.errorchecking.Check;

public class TerminationByEvaluations
implements Termination {
    private final int maximumNumberOfEvaluations;

    public TerminationByEvaluations(int maximumNumberOfEvaluations) {
        this.maximumNumberOfEvaluations = maximumNumberOfEvaluations;
    }

    @Override
    public boolean isMet(Map<String, Object> algorithmStatusData) {
        Check.notNull((Object)algorithmStatusData.get("EVALUATIONS"));
        int currentNumberOfEvaluations = (Integer)algorithmStatusData.get("EVALUATIONS");
        return currentNumberOfEvaluations >= this.maximumNumberOfEvaluations;
    }

    public int getMaximumNumberOfEvaluations() {
        return this.maximumNumberOfEvaluations;
    }
}

