/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.common.termination.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.util.NormalizeUtils;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.errorchecking.Check;

public class TerminationByQualityIndicator
implements Termination {
    private final QualityIndicator qualityIndicator;
    private final double[][] referenceFront;
    private final double percentage;
    private final double referenceFrontIndicatorValue;
    private final int evaluationsLimit;
    private int evaluations;
    private boolean evaluationsLimitReached;
    private double computedIndicatorValue;

    public TerminationByQualityIndicator(QualityIndicator qualityIndicator, double[][] referenceFront, double percentage, int evaluationsLimit) {
        Check.notNull((Object)qualityIndicator);
        Check.notNull((Object)referenceFront);
        Check.valueIsNotNegative((double)percentage);
        Check.valueIsNotNegative((double)evaluationsLimit);
        Check.that((referenceFront.length > 1 ? 1 : 0) != 0, (String)("The reference front must have at least two points instead of " + referenceFront.length));
        this.qualityIndicator = qualityIndicator;
        this.percentage = percentage;
        this.referenceFront = referenceFront;
        this.evaluationsLimit = evaluationsLimit;
        this.evaluationsLimitReached = false;
        double[][] normalizedReferenceFront = NormalizeUtils.normalize((double[][])referenceFront);
        qualityIndicator.referenceFront(normalizedReferenceFront);
        this.referenceFrontIndicatorValue = qualityIndicator.compute(normalizedReferenceFront);
    }

    @Override
    public boolean isMet(Map<String, Object> algorithmStatusData) {
        boolean unsuccessfulStopCondition;
        Check.notNull((Object)algorithmStatusData.get("POPULATION"));
        Check.notNull((Object)algorithmStatusData.get("EVALUATIONS"));
        List population = (List)algorithmStatusData.get("POPULATION");
        this.evaluations = (Integer)algorithmStatusData.get("EVALUATIONS");
        Check.notNull((Object)population);
        Check.collectionIsNotEmpty((Collection)population);
        boolean stoppingCondition = false;
        boolean bl = unsuccessfulStopCondition = this.evaluationsLimit <= this.evaluations;
        if (unsuccessfulStopCondition) {
            this.evaluationsLimitReached = true;
            stoppingCondition = true;
        } else {
            boolean successfulStopCondition;
            double[][] front = SolutionListUtils.getMatrixWithObjectiveValues((List)population);
            double[][] normalizedFront = NormalizeUtils.normalize((double[][])front, (double[])NormalizeUtils.getMinValuesOfTheColumnsOfAMatrix((double[][])this.referenceFront), (double[])NormalizeUtils.getMaxValuesOfTheColumnsOfAMatrix((double[][])this.referenceFront));
            this.computedIndicatorValue = this.qualityIndicator.compute(normalizedFront);
            boolean bl2 = successfulStopCondition = this.computedIndicatorValue >= this.percentage * this.referenceFrontIndicatorValue;
            if (successfulStopCondition) {
                stoppingCondition = true;
            }
        }
        return stoppingCondition;
    }

    public double getComputedIndicatorValue() {
        return this.computedIndicatorValue;
    }

    public double getReferenceFrontIndicatorValue() {
        return this.referenceFrontIndicatorValue;
    }

    public double getEvaluations() {
        return this.evaluations;
    }

    public boolean evaluationsLimitReached() {
        return this.evaluationsLimitReached;
    }

    public QualityIndicator getQualityIndicator() {
        return this.qualityIndicator;
    }

    public int getEvaluationsLimit() {
        return this.evaluationsLimit;
    }
}

