/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.replacement.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.component.catalogue.ea.selection.impl.PopulationAndNeighborhoodSelection;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.aggregationfunction.AggregationFunction;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.neighborhood.impl.WeightVectorNeighborhood;
import org.uma.jmetal.util.point.impl.IdealPoint;
import org.uma.jmetal.util.point.impl.NadirPoint;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;
import org.uma.jmetal.util.sequencegenerator.impl.IntegerPermutationGenerator;

public class MOEADReplacement<S extends Solution<?>>
implements Replacement<S> {
    private final PopulationAndNeighborhoodSelection<S> matingPoolSelection;
    private final WeightVectorNeighborhood<S> weightVectorNeighborhood;
    private final AggregationFunction aggregationFunction;
    private final SequenceGenerator<Integer> sequenceGenerator;
    private final int maximumNumberOfReplacedSolutions;
    private boolean normalize;
    private IdealPoint idealPoint = null;
    private NadirPoint nadirPoint = null;
    private NonDominatedSolutionListArchive<S> nonDominatedSolutionListArchive;
    private boolean firstReplacement = true;

    public MOEADReplacement(PopulationAndNeighborhoodSelection<S> matingPoolSelection, WeightVectorNeighborhood<S> weightVectorNeighborhood, AggregationFunction aggregationFunction, SequenceGenerator<Integer> sequenceGenerator, int maximumNumberOfReplacedSolutions, boolean normalize) {
        this.matingPoolSelection = matingPoolSelection;
        this.weightVectorNeighborhood = weightVectorNeighborhood;
        this.aggregationFunction = aggregationFunction;
        this.sequenceGenerator = sequenceGenerator;
        this.maximumNumberOfReplacedSolutions = maximumNumberOfReplacedSolutions;
        this.normalize = normalize;
    }

    @Override
    public List<S> replace(List<S> population, List<S> offspringPopulation) {
        Solution newSolution = (Solution)offspringPopulation.get(0);
        this.updateIdealPoint(population, newSolution);
        this.updateNadirPoint(population, newSolution);
        Neighborhood.NeighborType neighborType = this.matingPoolSelection.getNeighborType();
        IntegerPermutationGenerator randomPermutation = new IntegerPermutationGenerator(neighborType.equals((Object)Neighborhood.NeighborType.NEIGHBOR) ? this.weightVectorNeighborhood.neighborhoodSize() : population.size());
        int replacements = 0;
        for (int i = 0; i < randomPermutation.getSequenceLength() && replacements < this.maximumNumberOfReplacedSolutions; ++i) {
            int k = neighborType.equals((Object)Neighborhood.NeighborType.NEIGHBOR) ? this.weightVectorNeighborhood.getNeighborhood()[(Integer)this.sequenceGenerator.getValue()][randomPermutation.getValue()] : randomPermutation.getValue();
            randomPermutation.generateNext();
            double f1 = this.aggregationFunction.compute(((Solution)population.get(k)).objectives(), this.weightVectorNeighborhood.getWeightVector()[k], this.idealPoint, this.nadirPoint);
            double f2 = this.aggregationFunction.compute(newSolution.objectives(), this.weightVectorNeighborhood.getWeightVector()[k], this.idealPoint, this.nadirPoint);
            if (!(f2 < f1)) continue;
            population.set(k, newSolution.copy());
            ++replacements;
        }
        this.sequenceGenerator.generateNext();
        return population;
    }

    private void updateIdealPoint(List<S> population, S newSolution) {
        if (this.firstReplacement) {
            this.idealPoint = new IdealPoint(((Solution)population.get(0)).objectives().length);
            this.idealPoint.update(population);
            if (this.normalize) {
                this.nonDominatedSolutionListArchive = new NonDominatedSolutionListArchive();
                this.nonDominatedSolutionListArchive.addAll(population);
                this.nonDominatedSolutionListArchive.add(newSolution);
            }
            this.firstReplacement = false;
        }
        this.idealPoint.update(newSolution.objectives());
    }

    private void updateNadirPoint(List<S> population, S newSolution) {
        if (this.normalize) {
            this.nadirPoint = new NadirPoint(((Solution)population.get(0)).objectives().length);
            this.nonDominatedSolutionListArchive.add(newSolution);
            for (Solution solution : this.nonDominatedSolutionListArchive.solutions()) {
                this.nadirPoint.update(solution.objectives());
            }
        }
    }
}

