/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.replacement.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;

public class PairwiseReplacement<S extends Solution<?>>
implements Replacement<S> {
    protected Comparator<S> comparator;

    public PairwiseReplacement(Comparator<S> comparator) {
        this.comparator = comparator;
    }

    @Override
    public List<S> replace(List<S> population, List<S> offspringPopulation) {
        Check.that((population.size() == offspringPopulation.size() ? 1 : 0) != 0, (String)("The sizes of both populations is not the same: " + population.size() + ", " + offspringPopulation.size()));
        ArrayList<Solution> resultPopulation = new ArrayList<Solution>();
        for (int i = 0; i < population.size(); ++i) {
            if (this.comparator.compare((Solution)population.get(i), (Solution)offspringPopulation.get(i)) < 0) {
                resultPopulation.add((Solution)population.get(i));
                continue;
            }
            resultPopulation.add((Solution)offspringPopulation.get(i));
        }
        return resultPopulation;
    }
}

