/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.replacement.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.component.util.RankingAndDensityEstimatorPreference;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.ranking.Ranking;

public class RankingAndDensityEstimatorReplacement<S extends Solution<?>>
implements Replacement<S> {
    private Ranking<S> ranking;
    private DensityEstimator<S> densityEstimator;
    private Replacement.RemovalPolicy removalPolicy;

    public RankingAndDensityEstimatorReplacement(Ranking<S> ranking, DensityEstimator<S> densityEstimator) {
        this(ranking, densityEstimator, Replacement.RemovalPolicy.SEQUENTIAL);
    }

    public RankingAndDensityEstimatorReplacement(Ranking<S> ranking, DensityEstimator<S> densityEstimator, Replacement.RemovalPolicy removalPolicy) {
        this.ranking = ranking;
        this.densityEstimator = densityEstimator;
        this.removalPolicy = removalPolicy;
    }

    public RankingAndDensityEstimatorReplacement(RankingAndDensityEstimatorPreference<S> preference, Replacement.RemovalPolicy removalPolicy) {
        this.ranking = preference.getRanking();
        this.densityEstimator = preference.getDensityEstimator();
        this.removalPolicy = removalPolicy;
    }

    @Override
    public List<S> replace(List<S> solutionList, List<S> offspringList) {
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(solutionList);
        jointPopulation.addAll(offspringList);
        this.ranking.compute(jointPopulation);
        List<S> resultList = this.removalPolicy == Replacement.RemovalPolicy.ONE_SHOT ? this.oneShotTruncation(0, solutionList.size()) : this.sequentialTruncation(0, solutionList.size());
        return resultList;
    }

    private List<S> oneShotTruncation(int rankingId, int sizeOfTheResultingSolutionList) {
        List currentRankSolutions = this.ranking.getSubFront(rankingId);
        this.densityEstimator.compute(currentRankSolutions);
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (currentRankSolutions.size() < sizeOfTheResultingSolutionList) {
            resultList.addAll(this.ranking.getSubFront(rankingId));
            resultList.addAll(this.oneShotTruncation(rankingId + 1, sizeOfTheResultingSolutionList - currentRankSolutions.size()));
        } else {
            currentRankSolutions.sort(Comparator.comparing(arg_0 -> this.densityEstimator.value(arg_0)).reversed());
            int i = 0;
            while (resultList.size() < sizeOfTheResultingSolutionList) {
                resultList.add((Solution)currentRankSolutions.get(i));
                ++i;
            }
        }
        return resultList;
    }

    private List<S> sequentialTruncation(int rankingId, int sizeOfTheResultingSolutionList) {
        List currentRankSolutions = this.ranking.getSubFront(rankingId);
        this.densityEstimator.compute(currentRankSolutions);
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (currentRankSolutions.size() < sizeOfTheResultingSolutionList) {
            resultList.addAll(this.ranking.getSubFront(rankingId));
            resultList.addAll(this.sequentialTruncation(rankingId + 1, sizeOfTheResultingSolutionList - currentRankSolutions.size()));
        } else {
            for (Solution solution : currentRankSolutions) {
                resultList.add(solution);
            }
            while (resultList.size() > sizeOfTheResultingSolutionList) {
                resultList.sort(Comparator.comparing(arg_0 -> this.densityEstimator.value(arg_0)).reversed());
                resultList.remove(resultList.size() - 1);
                this.densityEstimator.compute(resultList);
            }
        }
        return resultList;
    }
}

