/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.replacement.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.replacement.Replacement;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.Hypervolume;
import org.uma.jmetal.util.legacy.qualityindicator.impl.hypervolume.impl.PISAHypervolume;
import org.uma.jmetal.util.ranking.Ranking;

public class SMSEMOAReplacement<S extends Solution<?>>
implements Replacement<S> {
    private Ranking<S> ranking;
    private Hypervolume<S> hypervolume;

    public SMSEMOAReplacement(Ranking<S> ranking) {
        this(ranking, (Hypervolume<S>)new PISAHypervolume());
    }

    public SMSEMOAReplacement(Ranking<S> ranking, Hypervolume<S> hypervolume) {
        this.ranking = ranking;
        this.hypervolume = hypervolume;
    }

    @Override
    public List<S> replace(List<S> solutionList, List<S> offspringList) {
        int i;
        ArrayList<S> jointPopulation = new ArrayList<S>();
        jointPopulation.addAll(solutionList);
        jointPopulation.addAll(offspringList);
        this.ranking.compute(jointPopulation);
        List lastSubFront = this.ranking.getSubFront(this.ranking.getNumberOfSubFronts() - 1);
        lastSubFront = this.hypervolume.computeHypervolumeContribution(lastSubFront, jointPopulation);
        ArrayList<Solution> resultPopulation = new ArrayList<Solution>();
        for (i = 0; i < this.ranking.getNumberOfSubFronts() - 1; ++i) {
            resultPopulation.addAll(this.ranking.getSubFront(i));
        }
        for (i = 0; i < lastSubFront.size() - 1; ++i) {
            resultPopulation.add((Solution)lastSubFront.get(i));
        }
        return resultPopulation;
    }
}

