/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.selection.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.selection.Selection;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class DifferentialEvolutionSelection
implements Selection<DoubleSolution> {
    private org.uma.jmetal.operator.selection.impl.DifferentialEvolutionSelection selectionOperator;
    private int matingPoolSize;
    private SequenceGenerator<Integer> solutionIndexGenerator;

    public DifferentialEvolutionSelection(int matingPoolSize, int numberOfParentsToSelect, boolean takeCurrentIndividualAsParent, SequenceGenerator<Integer> solutionIndexGenerator) {
        this.selectionOperator = new org.uma.jmetal.operator.selection.impl.DifferentialEvolutionSelection(numberOfParentsToSelect, takeCurrentIndividualAsParent);
        this.matingPoolSize = matingPoolSize;
        this.solutionIndexGenerator = solutionIndexGenerator;
    }

    @Override
    public List<DoubleSolution> select(List<DoubleSolution> solutionList) {
        ArrayList<DoubleSolution> matingPool = new ArrayList<DoubleSolution>(this.matingPoolSize);
        block0: while (matingPool.size() < this.matingPoolSize) {
            this.selectionOperator.setIndex(((Integer)this.solutionIndexGenerator.getValue()).intValue());
            List parents = this.selectionOperator.execute(solutionList);
            for (DoubleSolution parent : parents) {
                matingPool.add(parent);
                if (matingPool.size() != this.matingPoolSize) continue;
                continue block0;
            }
        }
        Check.that((this.matingPoolSize == matingPool.size() ? 1 : 0) != 0, (String)("The mating pool size " + matingPool.size() + " is not equal to the required size " + this.matingPoolSize));
        return matingPool;
    }
}

