/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.selection.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.selection.Selection;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class NeighborhoodSelection<S extends Solution<?>>
implements Selection<S> {
    private SelectionOperator<List<S>, S> selectionOperator;
    private int matingPoolSize;
    private boolean updateCurrentSolutionIndex;
    private SequenceGenerator<Integer> solutionIndexGenerator;
    private Neighborhood<S> neighborhood;

    public NeighborhoodSelection(int matingPoolSize, SequenceGenerator<Integer> solutionIndexGenerator, Neighborhood<S> neighborhood, SelectionOperator<List<S>, S> selectionOperator, boolean updateCurrentSolutionIndex) {
        this.matingPoolSize = matingPoolSize;
        this.solutionIndexGenerator = solutionIndexGenerator;
        this.neighborhood = neighborhood;
        this.selectionOperator = selectionOperator;
        this.updateCurrentSolutionIndex = updateCurrentSolutionIndex;
    }

    @Override
    public List<S> select(List<S> solutionList) {
        ArrayList<Solution> matingPool = new ArrayList<Solution>();
        while (matingPool.size() < this.matingPoolSize) {
            matingPool.add((Solution)this.selectionOperator.execute((Object)this.neighborhood.getNeighbors(solutionList, ((Integer)this.solutionIndexGenerator.getValue()).intValue())));
            if (!this.updateCurrentSolutionIndex) continue;
            this.solutionIndexGenerator.generateNext();
        }
        Check.that((this.matingPoolSize == matingPool.size() ? 1 : 0) != 0, (String)("The mating pool size " + matingPool.size() + " is not equal to the required size " + this.matingPoolSize));
        return matingPool;
    }

    public SequenceGenerator<Integer> getSolutionIndexGenerator() {
        return this.solutionIndexGenerator;
    }
}

