/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.selection.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.ea.selection.Selection;
import org.uma.jmetal.operator.selection.SelectionOperator;
import org.uma.jmetal.operator.selection.impl.NaryRandomSelection;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.neighborhood.Neighborhood;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class PopulationAndNeighborhoodSelection<S extends Solution<?>>
implements Selection<S> {
    private SelectionOperator<List<S>, List<S>> selectionOperator;
    private int matingPoolSize;
    private SequenceGenerator<Integer> solutionIndexGenerator;
    private Neighborhood<S> neighborhood;
    private Neighborhood.NeighborType neighborType;
    private double neighborhoodSelectionProbability;
    private boolean selectCurrentSolution;

    public PopulationAndNeighborhoodSelection(int matingPoolSize, SequenceGenerator<Integer> solutionIndexGenerator, Neighborhood<S> neighborhood, double neighborhoodSelectionProbability, boolean selectCurrentSolution) {
        this.matingPoolSize = matingPoolSize;
        this.solutionIndexGenerator = solutionIndexGenerator;
        this.neighborhood = neighborhood;
        this.neighborhoodSelectionProbability = neighborhoodSelectionProbability;
        this.selectCurrentSolution = selectCurrentSolution;
        this.selectionOperator = new NaryRandomSelection(selectCurrentSolution ? matingPoolSize - 1 : matingPoolSize);
    }

    @Override
    public List<S> select(List<S> solutionList) {
        List matingPool;
        if (JMetalRandom.getInstance().nextDouble() < this.neighborhoodSelectionProbability) {
            this.neighborType = Neighborhood.NeighborType.NEIGHBOR;
            matingPool = (List)this.selectionOperator.execute((Object)this.neighborhood.getNeighbors(solutionList, ((Integer)this.solutionIndexGenerator.getValue()).intValue()));
        } else {
            this.neighborType = Neighborhood.NeighborType.POPULATION;
            matingPool = (List)this.selectionOperator.execute(solutionList);
        }
        if (this.selectCurrentSolution) {
            matingPool.add((Solution)solutionList.get((Integer)this.solutionIndexGenerator.getValue()));
        }
        Check.that((this.matingPoolSize == matingPool.size() ? 1 : 0) != 0, (String)("The mating pool size " + matingPool.size() + " is not equal to the required size " + this.matingPoolSize));
        return matingPool;
    }

    public Neighborhood.NeighborType getNeighborType() {
        return this.neighborType;
    }

    public SequenceGenerator<Integer> getSolutionIndexGenerator() {
        return this.solutionIndexGenerator;
    }
}

