/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.selection.impl;

import java.io.Serializable;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.selection.Selection;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.ListUtils;
import org.uma.jmetal.util.pseudorandom.BoundedRandomGenerator;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class RandomSelection<S extends Solution<?>>
implements Selection<S> {
    private final int numberOfElementsToSelect;
    private final boolean withReplacement;
    private final BoundedRandomGenerator<Integer> randomGenerator;

    public RandomSelection(int numberOfElementsToSelect) {
        this(numberOfElementsToSelect, true);
    }

    public RandomSelection(int numberOfElementsToSelect, boolean withReplacement) {
        this(numberOfElementsToSelect, withReplacement, (BoundedRandomGenerator<Integer>)((BoundedRandomGenerator & Serializable)(arg_0, arg_1) -> ((JMetalRandom)JMetalRandom.getInstance()).nextInt(arg_0, arg_1)));
    }

    public RandomSelection(int numberOfElementsToSelect, boolean withReplacement, BoundedRandomGenerator<Integer> pseudoRandomGenerator) {
        this.numberOfElementsToSelect = numberOfElementsToSelect;
        this.withReplacement = withReplacement;
        this.randomGenerator = pseudoRandomGenerator;
    }

    @Override
    public List<S> select(List<S> solutionList) {
        List selectedSolutions = this.withReplacement ? ListUtils.randomSelectionWithReplacement((int)this.numberOfElementsToSelect, solutionList, this.randomGenerator) : ListUtils.randomSelectionWithoutReplacement((int)this.numberOfElementsToSelect, solutionList, this.randomGenerator);
        return selectedSolutions;
    }

    public boolean withReplacement() {
        return this.withReplacement;
    }

    public int getNumberOfElementsToSelect() {
        return this.numberOfElementsToSelect;
    }
}

