/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.variation.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.variation.Variation;
import org.uma.jmetal.operator.crossover.CrossoverOperator;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.errorchecking.JMetalException;

public class CrossoverAndMutationVariation<S extends Solution<?>>
implements Variation<S> {
    private CrossoverOperator<S> crossover;
    private MutationOperator<S> mutation;
    private int matingPoolSize;
    private int offspringPopulationSize;

    public CrossoverAndMutationVariation(int offspringPopulationSize, CrossoverOperator<S> crossover, MutationOperator<S> mutation) {
        this.crossover = crossover;
        this.mutation = mutation;
        this.offspringPopulationSize = offspringPopulationSize;
        this.matingPoolSize = offspringPopulationSize * crossover.numberOfRequiredParents() / crossover.numberOfGeneratedChildren();
        int remainder = this.matingPoolSize % crossover.numberOfRequiredParents();
        if (remainder != 0) {
            this.matingPoolSize += remainder;
        }
    }

    @Override
    public List<S> variate(List<S> population, List<S> matingPopulation) {
        int numberOfParents = this.crossover.numberOfRequiredParents();
        this.checkNumberOfParents(matingPopulation, numberOfParents);
        ArrayList<Solution> offspringPopulation = new ArrayList<Solution>(this.offspringPopulationSize);
        block0: for (int i = 0; i < this.matingPoolSize; i += numberOfParents) {
            ArrayList<Solution> parents = new ArrayList<Solution>(numberOfParents);
            for (int j = 0; j < numberOfParents; ++j) {
                parents.add((Solution)matingPopulation.get(i + j));
            }
            List offspring = (List)this.crossover.execute(parents);
            for (Solution s : offspring) {
                this.mutation.execute((Object)s);
                offspringPopulation.add(s);
                if (offspringPopulation.size() != this.offspringPopulationSize) continue;
                continue block0;
            }
        }
        Check.that((offspringPopulation.size() == this.offspringPopulationSize ? 1 : 0) != 0, (String)("The size of theoffspring population is not correct: " + offspringPopulation.size() + " instead of " + this.offspringPopulationSize));
        return offspringPopulation;
    }

    private void checkNumberOfParents(List<S> population, int numberOfParentsForCrossover) {
        if (population.size() % numberOfParentsForCrossover != 0) {
            throw new JMetalException("Wrong number of parents: the remainder if the population size (" + population.size() + ") is not divisible by " + numberOfParentsForCrossover);
        }
    }

    @Override
    public int getMatingPoolSize() {
        return this.matingPoolSize;
    }

    @Override
    public int getOffspringPopulationSize() {
        return this.offspringPopulationSize;
    }
}

