/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.ea.variation.impl;

import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.component.catalogue.ea.variation.Variation;
import org.uma.jmetal.operator.crossover.impl.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.NullMutation;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;

public class DifferentialEvolutionCrossoverVariation
implements Variation<DoubleSolution> {
    private int matingPoolSize;
    private int offspringPopulationSize;
    private SequenceGenerator<Integer> solutionIndexGenerator;
    private DifferentialEvolutionCrossover crossover;
    private MutationOperator<DoubleSolution> mutation;

    public DifferentialEvolutionCrossoverVariation(int offspringPopulationSize, DifferentialEvolutionCrossover crossover, MutationOperator<DoubleSolution> mutation, SequenceGenerator<Integer> solutionIndexGenerator) {
        this.offspringPopulationSize = offspringPopulationSize;
        this.crossover = crossover;
        this.mutation = mutation;
        this.solutionIndexGenerator = solutionIndexGenerator;
        this.matingPoolSize = offspringPopulationSize * crossover.numberOfRequiredParents();
    }

    public DifferentialEvolutionCrossoverVariation(int offspringPopulationSize, DifferentialEvolutionCrossover crossover, SequenceGenerator<Integer> solutionIndexGenerator) {
        this(offspringPopulationSize, crossover, (MutationOperator<DoubleSolution>)new NullMutation(), solutionIndexGenerator);
    }

    @Override
    public List<DoubleSolution> variate(List<DoubleSolution> solutionList, List<DoubleSolution> matingPool) {
        ArrayList<DoubleSolution> offspringPopulation = new ArrayList<DoubleSolution>();
        while (offspringPopulation.size() < this.offspringPopulationSize) {
            this.crossover.setCurrentSolution(solutionList.get((Integer)this.solutionIndexGenerator.getValue()));
            int numberOfRequiredParentsToCross = this.crossover.numberOfRequiredParents();
            ArrayList<DoubleSolution> parents = new ArrayList<DoubleSolution>(numberOfRequiredParentsToCross);
            for (int j = 0; j < numberOfRequiredParentsToCross; ++j) {
                parents.add(matingPool.get(j));
            }
            List offspring = this.crossover.execute(parents);
            offspringPopulation.add((DoubleSolution)this.mutation.execute((Object)((DoubleSolution)offspring.get(0))));
        }
        return offspringPopulation;
    }

    public DifferentialEvolutionCrossover getCrossover() {
        return this.crossover;
    }

    public MutationOperator<DoubleSolution> getMutation() {
        return this.mutation;
    }

    @Override
    public int getMatingPoolSize() {
        return this.matingPoolSize;
    }

    @Override
    public int getOffspringPopulationSize() {
        return this.offspringPopulationSize;
    }
}

