/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.pso.perturbation.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.pso.perturbation.Perturbation;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class FrequencySelectionMutationBasedPerturbation
implements Perturbation {
    private MutationOperator<DoubleSolution> mutationOperator;
    private int frequencyOfApplication;
    private JMetalRandom randomGenerator;

    public FrequencySelectionMutationBasedPerturbation(MutationOperator<DoubleSolution> mutationOperator, int frequencyOfApplication) {
        this.mutationOperator = mutationOperator;
        this.frequencyOfApplication = frequencyOfApplication;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public FrequencySelectionMutationBasedPerturbation(MutationOperator<DoubleSolution> mutationOperator) {
        this(mutationOperator, 7);
    }

    @Override
    public List<DoubleSolution> perturb(List<DoubleSolution> swarm) {
        Check.notNull(swarm);
        Check.that((swarm.size() > 0 ? 1 : 0) != 0, (String)("The swarm size is empty: " + swarm.size()));
        for (int i = 0; i < swarm.size(); ++i) {
            if (i % this.frequencyOfApplication != 0) continue;
            this.mutationOperator.execute((Object)swarm.get(i));
        }
        return swarm;
    }

    public MutationOperator<DoubleSolution> getMutationOperator() {
        return this.mutationOperator;
    }

    public double getFrequencyOfApplication() {
        return this.frequencyOfApplication;
    }
}

