/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.pso.positionupdate.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.pso.positionupdate.PositionUpdate;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;

public class DefaultPositionUpdate
implements PositionUpdate {
    protected double velocityChangeWhenLowerLimitIsReached;
    protected double velocityChangeWhenUpperLimitIsReached;
    List<Bounds<Double>> positionBounds;

    public DefaultPositionUpdate(double velocityChangeWhenLowerLimitIsReached, double velocityChangeWhenUpperLimitIsReached, List<Bounds<Double>> positionBounds) {
        this.velocityChangeWhenLowerLimitIsReached = velocityChangeWhenLowerLimitIsReached;
        this.velocityChangeWhenUpperLimitIsReached = velocityChangeWhenUpperLimitIsReached;
        Check.notNull(positionBounds);
        this.positionBounds = positionBounds;
    }

    @Override
    public List<DoubleSolution> update(List<DoubleSolution> swarm, double[][] speed) {
        Check.notNull(swarm);
        Check.that((!swarm.isEmpty() ? 1 : 0) != 0, (String)("The swarm is empty: " + swarm.size()));
        Check.that((swarm.get(0).variables().size() == this.positionBounds.size() ? 1 : 0) != 0, (String)("The sizes of the list of bounds and variables do not match: " + this.positionBounds.size() + " vs " + swarm.get(0).variables().size()));
        Check.that((swarm.size() == speed.length ? 1 : 0) != 0, (String)("The sizes of the list of particles and the speed matrix do not match: " + swarm.size() + " vs " + speed.length));
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle = swarm.get(i);
            for (int j = 0; j < particle.variables().size(); ++j) {
                particle.variables().set(j, (Double)particle.variables().get(j) + speed[i][j]);
                Bounds<Double> bounds = this.positionBounds.get(j);
                Double lowerBound = (Double)bounds.getLowerBound();
                Double upperBound = (Double)bounds.getUpperBound();
                if ((Double)particle.variables().get(j) < lowerBound) {
                    particle.variables().set(j, lowerBound);
                    speed[i][j] = speed[i][j] * this.velocityChangeWhenLowerLimitIsReached;
                }
                if (!((Double)particle.variables().get(j) > upperBound)) continue;
                particle.variables().set(j, upperBound);
                speed[i][j] = speed[i][j] * this.velocityChangeWhenUpperLimitIsReached;
            }
        }
        return swarm;
    }

    public double getVelocityChangeWhenLowerLimitIsReached() {
        return this.velocityChangeWhenLowerLimitIsReached;
    }

    public double getVelocityChangeWhenUpperLimitIsReached() {
        return this.velocityChangeWhenUpperLimitIsReached;
    }
}

