/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.pso.velocityinitialization.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.pso.velocityinitialization.VelocityInitialization;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.errorchecking.Check;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;

public class SPSO2007VelocityInitialization
implements VelocityInitialization {
    @Override
    public double[][] initialize(List<DoubleSolution> swarm) {
        Check.notNull(swarm);
        Check.that((!swarm.isEmpty() ? 1 : 0) != 0, (String)("The swarm size is empty: " + swarm.size()));
        int numberOfVariables = swarm.get(0).variables().size();
        double[][] speed = new double[swarm.size()][numberOfVariables];
        PseudoRandomGenerator randomGenerator = JMetalRandom.getInstance().getRandomGenerator();
        for (int i = 0; i < speed.length; ++i) {
            DoubleSolution particle = swarm.get(i);
            for (int j = 0; j < numberOfVariables; ++j) {
                Bounds bounds = particle.getBounds(j);
                speed[i][j] = (randomGenerator.nextDouble(((Double)bounds.getLowerBound()).doubleValue(), ((Double)bounds.getUpperBound()).doubleValue()) - (Double)particle.variables().get(j)) / 2.0;
            }
        }
        return speed;
    }
}

