/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.pso.velocityupdate.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.pso.globalbestselection.GlobalBestSelection;
import org.uma.jmetal.component.catalogue.pso.inertiaweightcomputingstrategy.InertiaWeightComputingStrategy;
import org.uma.jmetal.component.catalogue.pso.velocityupdate.VelocityUpdate;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.bounds.Bounds;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class ConstrainedVelocityUpdate
implements VelocityUpdate {
    protected double c1Max;
    protected double c1Min;
    protected double c2Max;
    protected double c2Min;
    protected double r1Max;
    protected double r1Min;
    protected double r2Max;
    protected double r2Min;
    protected JMetalRandom randomGenerator;
    protected double[] deltaMax;
    protected double[] deltaMin;

    public ConstrainedVelocityUpdate(double r1Min, double r1Max, double r2Min, double r2Max, double c1Min, double c1Max, double c2Min, double c2Max, DoubleProblem problem) {
        this.r1Max = r1Max;
        this.r1Min = r1Min;
        this.r2Max = r2Max;
        this.r2Min = r2Min;
        this.c1Max = c1Max;
        this.c1Min = c1Min;
        this.c2Max = c2Max;
        this.c2Min = c2Min;
        this.randomGenerator = JMetalRandom.getInstance();
        this.deltaMax = new double[problem.numberOfVariables()];
        this.deltaMin = new double[problem.numberOfVariables()];
        for (int i = 0; i < problem.numberOfVariables(); ++i) {
            Bounds bounds = (Bounds)problem.variableBounds().get(i);
            this.deltaMax[i] = ((Double)bounds.getUpperBound() - (Double)bounds.getLowerBound()) / 2.0;
            this.deltaMin[i] = -this.deltaMax[i];
        }
    }

    public ConstrainedVelocityUpdate(double c1Min, double c1Max, double c2Min, double c2Max, DoubleProblem problem) {
        this(0.0, 1.0, 0.0, 1.0, c1Min, c1Max, c2Min, c2Max, problem);
    }

    @Override
    public double[][] update(List<DoubleSolution> swarm, double[][] speed, DoubleSolution[] localBest, BoundedArchive<DoubleSolution> leaders, GlobalBestSelection globalBestSelection, InertiaWeightComputingStrategy inertiaWeightComputingStrategy) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle = (DoubleSolution)swarm.get(i).copy();
            DoubleSolution bestParticle = (DoubleSolution)localBest[i].copy();
            DoubleSolution bestGlobal = globalBestSelection.select(leaders.solutions());
            double r1 = this.randomGenerator.nextDouble(this.r1Min, this.r1Max);
            double r2 = this.randomGenerator.nextDouble(this.r2Min, this.r2Max);
            double c1 = this.randomGenerator.nextDouble(this.c1Min, this.c1Max);
            double c2 = this.randomGenerator.nextDouble(this.c2Min, this.c2Max);
            double inertiaWeight = inertiaWeightComputingStrategy.compute();
            for (int j = 0; j < particle.variables().size(); ++j) {
                speed[i][j] = this.velocityConstriction(this.constrictionCoefficient(c1, c2) * (inertiaWeight * speed[i][j] + c1 * r1 * ((Double)bestParticle.variables().get(j) - (Double)particle.variables().get(j)) + c2 * r2 * ((Double)bestGlobal.variables().get(j) - (Double)particle.variables().get(j))), this.deltaMax, this.deltaMin, j);
            }
        }
        return speed;
    }

    private double velocityConstriction(double v, double[] deltaMax, double[] deltaMin, int variableIndex) {
        double dmax = deltaMax[variableIndex];
        double dmin = deltaMin[variableIndex];
        double result = v;
        if (v > dmax) {
            result = dmax;
        }
        if (v < dmin) {
            result = dmin;
        }
        return result;
    }

    protected double constrictionCoefficient(double c1, double c2) {
        double rho = c1 + c2;
        if (rho <= 4.0) {
            return 1.0;
        }
        return 2.0 / (2.0 - rho - Math.sqrt(Math.pow(rho, 2.0) - 4.0 * rho));
    }
}

