/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.catalogue.pso.velocityupdate.impl;

import java.util.List;
import org.uma.jmetal.component.catalogue.pso.globalbestselection.GlobalBestSelection;
import org.uma.jmetal.component.catalogue.pso.inertiaweightcomputingstrategy.InertiaWeightComputingStrategy;
import org.uma.jmetal.component.catalogue.pso.velocityupdate.VelocityUpdate;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.SolutionUtils;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.pseudorandom.PseudoRandomGenerator;
import org.uma.jmetal.util.pseudorandom.impl.ExtendedPseudoRandomGenerator;
import org.uma.jmetal.util.pseudorandom.impl.JavaRandomGenerator;

public class SPS2011VelocityUpdate
implements VelocityUpdate {
    protected double c1Max;
    protected double c1Min;
    protected double c2Max;
    protected double c2Min;
    protected JMetalRandom randomGenerator;
    private DoubleProblem problem;

    public SPS2011VelocityUpdate(double c1Min, double c1Max, double c2Min, double c2Max, DoubleProblem problem) {
        this.c1Max = c1Max;
        this.c1Min = c1Min;
        this.c2Max = c2Max;
        this.c2Min = c2Min;
        this.problem = problem;
        this.randomGenerator = JMetalRandom.getInstance();
        this.randomGenerator.setRandomGenerator((PseudoRandomGenerator)new ExtendedPseudoRandomGenerator((PseudoRandomGenerator)new JavaRandomGenerator()));
    }

    @Override
    public double[][] update(List<DoubleSolution> swarm, double[][] speed, DoubleSolution[] localBest, BoundedArchive<DoubleSolution> leaders, GlobalBestSelection globalBestSelection, InertiaWeightComputingStrategy inertiaWeightComputingStrategy) {
        for (int i = 0; i < swarm.size(); ++i) {
            DoubleSolution particle = (DoubleSolution)swarm.get(i).copy();
            DoubleSolution globalBestParticle = globalBestSelection.select(leaders.solutions());
            double r1 = this.randomGenerator.nextDouble(0.0, 1.0);
            double r2 = this.randomGenerator.nextDouble(0.0, 1.0);
            double c1 = this.randomGenerator.nextDouble(this.c1Min, this.c1Max);
            double c2 = this.randomGenerator.nextDouble(this.c2Min, this.c2Max);
            DoubleSolution gravityCenter = (DoubleSolution)this.problem.createSolution();
            for (int j = 0; j < particle.variables().size(); ++j) {
                double value = ((Double)particle.variables().get(j) + (Double)particle.variables().get(j) + c1 * r1 * ((Double)localBest[i].variables().get(j) - (Double)particle.variables().get(j)) + (Double)particle.variables().get(j) + c2 * r2 * ((Double)globalBestParticle.variables().get(j) - (Double)particle.variables().get(j))) / 3.0;
                gravityCenter.variables().set(j, value);
            }
            double radius = SolutionUtils.distanceBetweenSolutionsInObjectiveSpace((DoubleSolution)gravityCenter, (DoubleSolution)particle);
            double[] random = ((ExtendedPseudoRandomGenerator)this.randomGenerator.getRandomGenerator()).randSphere(this.problem.numberOfVariables());
            DoubleSolution randomParticle = (DoubleSolution)this.problem.createSolution();
            for (int j = 0; j < particle.variables().size(); ++j) {
                randomParticle.variables().set(j, (Double)gravityCenter.variables().get(j) + radius * random[j]);
            }
            double inertiaWeight = inertiaWeightComputingStrategy.compute();
            for (int j = 0; j < particle.variables().size(); ++j) {
                speed[i][j] = inertiaWeight * speed[i][j] + (Double)randomParticle.variables().get(j) - (Double)particle.variables().get(j);
            }
        }
        return speed;
    }
}

