/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.moead;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.MOEADBuilder;
import org.uma.jmetal.component.catalogue.common.evaluation.impl.SequentialEvaluationWithArchive;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.ProblemFactory;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.archive.Archive;
import org.uma.jmetal.util.archive.impl.BestSolutionsArchive;
import org.uma.jmetal.util.archive.impl.NonDominatedSolutionListArchive;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.sequencegenerator.SequenceGenerator;
import org.uma.jmetal.util.sequencegenerator.impl.IntegerPermutationGenerator;

public class MOEADWithUnboundedArchiveExample {
    public static void main(String[] args) throws JMetalException, IOException {
        String problemName = "org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2Minus";
        Problem problem = ProblemFactory.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int populationSize = 91;
        TerminationByEvaluations termination = new TerminationByEvaluations(30000);
        String weightVectorDirectory = "resources/weightVectorFiles/moead";
        IntegerPermutationGenerator sequenceGenerator = new IntegerPermutationGenerator(populationSize);
        BestSolutionsArchive externalArchive = new BestSolutionsArchive((Archive)new NonDominatedSolutionListArchive(), populationSize);
        boolean normalizeObjectives = false;
        EvolutionaryAlgorithm moead = new MOEADBuilder(problem, populationSize, crossover, mutation, weightVectorDirectory, (SequenceGenerator<Integer>)sequenceGenerator, normalizeObjectives).setTermination(termination).setEvaluation(new SequentialEvaluationWithArchive(problem, externalArchive)).build();
        moead.run();
        List population = externalArchive.solutions();
        JMetalLogger.logger.info("Total execution time : " + moead.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + moead.numberOfEvaluations());
        new SolutionListOutput(population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

