/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.nsgaii;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.NSGAIIBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.SinglePointCrossover;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.problem.multiobjective.zdt.ZDT5;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class NSGAIIBinaryProblemExample {
    public static void main(String[] args) throws JMetalException, IOException {
        ZDT5 problem = new ZDT5();
        SinglePointCrossover crossover = new SinglePointCrossover(0.9);
        BitFlipMutation mutation = new BitFlipMutation(1.0 / (double)problem.totalNumberOfBits());
        int populationSize = 100;
        int offspringPopulationSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(25000);
        EvolutionaryAlgorithm nsgaii = new NSGAIIBuilder(problem, populationSize, offspringPopulationSize, crossover, mutation).setTermination(termination).build();
        nsgaii.run();
        Object population = nsgaii.result();
        JMetalLogger.logger.info("Total execution time : " + nsgaii.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + nsgaii.numberOfEvaluations());
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

