/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.nsgaii;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.NSGAIIBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.SinglePointCrossover;
import org.uma.jmetal.operator.mutation.impl.BitFlipMutation;
import org.uma.jmetal.problem.multiobjective.multiobjectiveknapsack.MultiObjectiveKnapsack;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.constraintcomparator.ConstraintComparator;
import org.uma.jmetal.util.comparator.constraintcomparator.impl.OverallConstraintViolationDegreeComparator;
import org.uma.jmetal.util.comparator.dominanceComparator.impl.DominanceWithConstraintsComparator;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.FrontPlotObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.ranking.impl.FastNonDominatedSortRanking;

public class NSGAIIBiobjectiveKnapsackExample {
    public static void main(String[] args) throws JMetalException, IOException {
        MultiObjectiveKnapsack problem = MultiObjectiveKnapsack.readMKP((String)"resources/mokpInstances/1B-B/2KP50-1B.dat");
        SinglePointCrossover crossover = new SinglePointCrossover(0.9);
        double mutationProbability = 1.0 / (double)problem.totalNumberOfBits();
        BitFlipMutation mutation = new BitFlipMutation(mutationProbability);
        int populationSize = 100;
        int offspringPopulationSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(100000);
        FastNonDominatedSortRanking ranking = new FastNonDominatedSortRanking((Comparator)new DominanceWithConstraintsComparator((ConstraintComparator)new OverallConstraintViolationDegreeComparator()));
        EvolutionaryAlgorithm nsgaii = new NSGAIIBuilder(problem, populationSize, offspringPopulationSize, crossover, mutation).setTermination(termination).setRanking(ranking).build();
        FrontPlotObserver chartObserver = new FrontPlotObserver("NSGA-II", "F1", "F2", problem.name(), 10000);
        nsgaii.observable().register((Observer)chartObserver);
        nsgaii.run();
        Object population = nsgaii.result();
        JMetalLogger.logger.info("Total execution time : " + nsgaii.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + nsgaii.numberOfEvaluations());
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

