/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.nsgaii;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.NSGAIIBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.ProblemFactory;
import org.uma.jmetal.qualityindicator.QualityIndicatorUtils;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class NSGAIIDefaultConfigurationExample {
    public static void main(String[] args) throws JMetalException, IOException {
        String problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT1";
        String referenceParetoFront = "resources/referenceFrontsCSV/ZDT1.csv";
        Problem problem = ProblemFactory.loadProblem((String)problemName);
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int populationSize = 100;
        int offspringPopulationSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(25000);
        EvolutionaryAlgorithm nsgaii = new NSGAIIBuilder(problem, populationSize, offspringPopulationSize, crossover, mutation).setTermination(termination).build();
        nsgaii.run();
        Object population = nsgaii.result();
        JMetalLogger.logger.info("Total execution time : " + nsgaii.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + nsgaii.numberOfEvaluations());
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
        QualityIndicatorUtils.printQualityIndicators((double[][])SolutionListUtils.getMatrixWithObjectiveValues((List)population), (double[][])VectorUtils.readVectors((String)referenceParetoFront, (String)","));
    }
}

