/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.nsgaii;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.NSGAIIBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.IntegerSBXCrossover;
import org.uma.jmetal.operator.mutation.impl.IntegerPolynomialMutation;
import org.uma.jmetal.problem.multiobjective.SimpleIntegerProblem;
import org.uma.jmetal.solution.integersolution.IntegerSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.constraintcomparator.ConstraintComparator;
import org.uma.jmetal.util.comparator.constraintcomparator.impl.OverallConstraintViolationDegreeComparator;
import org.uma.jmetal.util.comparator.dominanceComparator.impl.DominanceWithConstraintsComparator;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.FrontPlotObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;
import org.uma.jmetal.util.ranking.impl.FastNonDominatedSortRanking;

public class NSGAIIIntegerProblemExample {
    public static void main(String[] args) throws JMetalException, IOException {
        SimpleIntegerProblem problem = new SimpleIntegerProblem();
        IntegerSBXCrossover crossover = new IntegerSBXCrossover(1.0, 20.0);
        IntegerPolynomialMutation mutation = new IntegerPolynomialMutation(1.0 / (double)problem.numberOfVariables(), 20.0);
        int populationSize = 100;
        int offspringPopulationSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(2500);
        FastNonDominatedSortRanking ranking = new FastNonDominatedSortRanking((Comparator)new DominanceWithConstraintsComparator((ConstraintComparator)new OverallConstraintViolationDegreeComparator()));
        EvolutionaryAlgorithm nsgaii = new NSGAIIBuilder(problem, populationSize, offspringPopulationSize, crossover, mutation).setTermination(termination).setRanking(ranking).build();
        FrontPlotObserver chartObserver = new FrontPlotObserver("NSGA-II", "F1", "F2", problem.name(), 1);
        nsgaii.observable().register((Observer)chartObserver);
        nsgaii.run();
        Object population = nsgaii.result();
        Iterator iterator = population.iterator();
        while (iterator.hasNext()) {
            IntegerSolution solution = (IntegerSolution)iterator.next();
            double[] dArray = solution.objectives();
            dArray[0] = dArray[0] * -1.0;
        }
        JMetalLogger.logger.info("Total execution time : " + nsgaii.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + nsgaii.numberOfEvaluations());
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

