/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.smpso;

import java.util.List;
import org.uma.jmetal.component.algorithm.ParticleSwarmOptimizationAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.SMPSOBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.problem.multiobjective.ebes.Ebes;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.RunTimeChartObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SMPSOSolvingEbes
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String referenceParetoFront = null;
        Ebes problem = new Ebes("resources/ebes/Mobile_Bridge_25N_35B_8G_16OrdZXY.ebe", new String[]{"W", "D"});
        int swarmSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(25000);
        ParticleSwarmOptimizationAlgorithm smpso = new SMPSOBuilder((DoubleProblem)problem, swarmSize).setTermination(termination).build();
        smpso.observable().register((Observer)new RunTimeChartObserver("SMPSO", 80, 1000, referenceParetoFront));
        smpso.run();
        Object population = smpso.result();
        JMetalLogger.logger.info("Total execution time : " + smpso.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + String.valueOf(smpso.evaluation()));
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

