/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.smpso;

import java.util.List;
import org.uma.jmetal.component.algorithm.ParticleSwarmOptimizationAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.SMPSOBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.ProblemFactory;
import org.uma.jmetal.problem.doubleproblem.DoubleProblem;
import org.uma.jmetal.qualityindicator.QualityIndicatorUtils;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.RunTimeChartObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SMPSOWithRealTimeChartExample
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws Exception {
        String problemName = "org.uma.jmetal.problem.multiobjective.zdt.ZDT4";
        String referenceParetoFront = "resources/referenceFrontsCSV/ZDT4.csv";
        Problem problem = ProblemFactory.loadProblem((String)problemName);
        int swarmSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(25000);
        ParticleSwarmOptimizationAlgorithm smpso = new SMPSOBuilder((DoubleProblem)problem, swarmSize).setTermination(termination).build();
        smpso.observable().register((Observer)new RunTimeChartObserver("SMPSO", 80, 100, referenceParetoFront));
        smpso.run();
        Object population = smpso.result();
        JMetalLogger.logger.info("Total execution time : " + smpso.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + String.valueOf(smpso.evaluation()));
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
        QualityIndicatorUtils.printQualityIndicators((double[][])SolutionListUtils.getMatrixWithObjectiveValues((List)population), (double[][])VectorUtils.readVectors((String)referenceParetoFront, (String)","));
    }
}

