/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.multiobjective.smsemoa;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.multiobjective.SMSEMOADEBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.DifferentialEvolutionCrossover;
import org.uma.jmetal.operator.mutation.MutationOperator;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.problem.ProblemFactory;
import org.uma.jmetal.qualityindicator.QualityIndicatorUtils;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.VectorUtils;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.EvaluationObserver;
import org.uma.jmetal.util.observer.impl.FrontPlotObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class SMSEMOADESolving3DProblemWithRealTimeChartExample {
    public static void main(String[] args) throws JMetalException, IOException {
        String problemName = "org.uma.jmetal.problem.multiobjective.dtlz.DTLZ2";
        String referenceParetoFront = "resources/referenceFrontsCSV/DTLZ2.3D.csv";
        Problem problem = ProblemFactory.loadProblem((String)problemName);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int populationSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(40000);
        double cr = 1.0;
        double f = 0.5;
        EvolutionaryAlgorithm<DoubleSolution> smsemoa = new SMSEMOADEBuilder((Problem<DoubleSolution>)problem, populationSize, cr, f, (MutationOperator<DoubleSolution>)mutation, DifferentialEvolutionCrossover.DE_VARIANT.RAND_1_BIN).setTermination(termination).build();
        EvaluationObserver evaluationObserver = new EvaluationObserver(Integer.valueOf(1000));
        FrontPlotObserver chartObserver = new FrontPlotObserver("SMS-EMOA-DE", "F1", "F2", problem.name(), 1000);
        chartObserver.setFront(VectorUtils.readVectors((String)referenceParetoFront, (String)","), "Reference front");
        smsemoa.observable().register((Observer)evaluationObserver);
        smsemoa.observable().register((Observer)chartObserver);
        smsemoa.run();
        Object population = smsemoa.result();
        JMetalLogger.logger.info("Total execution time : " + smsemoa.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + smsemoa.numberOfEvaluations());
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
        QualityIndicatorUtils.printQualityIndicators((double[][])SolutionListUtils.getMatrixWithObjectiveValues((List)population), (double[][])VectorUtils.readVectors((String)referenceParetoFront, (String)","));
    }
}

