/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.singleobjective.geneticalgorithm;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.singleobjective.GeneticAlgorithmBuilder;
import org.uma.jmetal.component.catalogue.common.evaluation.impl.MultiThreadedEvaluation;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.SBXCrossover;
import org.uma.jmetal.operator.mutation.impl.PolynomialMutation;
import org.uma.jmetal.problem.singleobjective.Sphere;
import org.uma.jmetal.solution.doublesolution.DoubleSolution;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class GenerationalGeneticAlgorithmWithMultiThreadedEvaluatorExample {
    public static void main(String[] args) throws JMetalException, IOException {
        int populationSize;
        Sphere problem = new Sphere(Integer.valueOf(20));
        double crossoverProbability = 0.9;
        double crossoverDistributionIndex = 20.0;
        SBXCrossover crossover = new SBXCrossover(crossoverProbability, crossoverDistributionIndex);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        double mutationDistributionIndex = 20.0;
        PolynomialMutation mutation = new PolynomialMutation(mutationProbability, mutationDistributionIndex);
        int offspringPopulationSize = populationSize = 100;
        TerminationByEvaluations termination = new TerminationByEvaluations(125000);
        MultiThreadedEvaluation evaluation = new MultiThreadedEvaluation(8, problem);
        EvolutionaryAlgorithm geneticAlgorithm = new GeneticAlgorithmBuilder("GGA", problem, populationSize, offspringPopulationSize, crossover, mutation).setTermination(termination).setEvaluation(evaluation).build();
        geneticAlgorithm.run();
        Object population = geneticAlgorithm.result();
        JMetalLogger.logger.info("Total execution time : " + geneticAlgorithm.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + geneticAlgorithm.numberOfEvaluations());
        JMetalLogger.logger.info("Best fitness: " + ((DoubleSolution)geneticAlgorithm.result().get(0)).objectives()[0]);
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

