/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.singleobjective.geneticalgorithm;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.algorithm.singleobjective.GeneticAlgorithmBuilder;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.operator.crossover.impl.PMXCrossover;
import org.uma.jmetal.operator.mutation.impl.PermutationSwapMutation;
import org.uma.jmetal.problem.singleobjective.TSP;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.FitnessObserver;
import org.uma.jmetal.util.observer.impl.FitnessPlotObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class GeneticAlgorithmTSPExample
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        int populationSize;
        TSP problem = new TSP("resources/tspInstances/kroA100.tsp");
        int offspringPopulationSize = populationSize = 100;
        PMXCrossover crossover = new PMXCrossover(0.9);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        PermutationSwapMutation mutation = new PermutationSwapMutation(mutationProbability);
        TerminationByEvaluations termination = new TerminationByEvaluations(1500000);
        EvolutionaryAlgorithm geneticAlgorithm = new GeneticAlgorithmBuilder("GGA", problem, populationSize, offspringPopulationSize, crossover, mutation).setTermination(termination).build();
        geneticAlgorithm.observable().register((Observer)new FitnessObserver(Integer.valueOf(20000)));
        FitnessPlotObserver chartObserver = new FitnessPlotObserver("Genetic algorithm", "Evaluations", "Fitness", "fitness", 100);
        geneticAlgorithm.observable().register((Observer)chartObserver);
        geneticAlgorithm.run();
        Object population = geneticAlgorithm.result();
        JMetalLogger.logger.info("Total execution time : " + geneticAlgorithm.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + geneticAlgorithm.numberOfEvaluations());
        JMetalLogger.logger.info("Best found solution: " + ((PermutationSolution)population.get(0)).objectives()[0]);
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

