/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.singleobjective.geneticalgorithm;

import java.io.IOException;
import java.util.List;
import org.uma.jmetal.component.algorithm.EvolutionaryAlgorithm;
import org.uma.jmetal.component.catalogue.common.evaluation.impl.SequentialEvaluation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.impl.RandomSolutionsCreation;
import org.uma.jmetal.component.catalogue.common.termination.Termination;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.component.catalogue.ea.replacement.impl.MuPlusLambdaReplacement;
import org.uma.jmetal.component.catalogue.ea.selection.impl.NaryTournamentSelection;
import org.uma.jmetal.component.catalogue.ea.variation.impl.CrossoverAndMutationVariation;
import org.uma.jmetal.operator.crossover.impl.PMXCrossover;
import org.uma.jmetal.operator.mutation.impl.PermutationSwapMutation;
import org.uma.jmetal.problem.singleobjective.TSP;
import org.uma.jmetal.solution.permutationsolution.PermutationSolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.comparator.MultiComparator;
import org.uma.jmetal.util.comparator.ObjectiveComparator;
import org.uma.jmetal.util.comparator.constraintcomparator.impl.OverallConstraintViolationDegreeComparator;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.FitnessPlotObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class GeneticAlgorithmTSPWithConstraintsExample
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException, IOException {
        int populationSize;
        TSP problem = new TSP("resources/tspInstances/kroA100.tsp"){

            public int numberOfConstraints() {
                return 1;
            }

            public PermutationSolution<Integer> evaluate(PermutationSolution<Integer> solution) {
                super.evaluate(solution);
                int city = 17;
                int cityPosition = solution.variables().indexOf(city);
                int constraint = 0 - cityPosition;
                solution.constraints()[0] = constraint;
                return solution;
            }
        };
        int offspringPopulationSize = populationSize = 100;
        RandomSolutionsCreation createInitialPopulation = new RandomSolutionsCreation(problem, populationSize);
        MultiComparator comparator = new MultiComparator(List.of(new OverallConstraintViolationDegreeComparator(), new ObjectiveComparator(0)));
        MuPlusLambdaReplacement replacement = new MuPlusLambdaReplacement(comparator);
        PMXCrossover crossover = new PMXCrossover(0.9);
        double mutationProbability = 1.0 / (double)problem.numberOfVariables();
        PermutationSwapMutation mutation = new PermutationSwapMutation(mutationProbability);
        CrossoverAndMutationVariation variation = new CrossoverAndMutationVariation(offspringPopulationSize, crossover, mutation);
        NaryTournamentSelection selection = new NaryTournamentSelection(2, variation.getMatingPoolSize(), new ObjectiveComparator(0));
        TerminationByEvaluations termination = new TerminationByEvaluations(500000);
        SequentialEvaluation evaluation = new SequentialEvaluation(problem);
        EvolutionaryAlgorithm<PermutationSolution<Integer>> geneticAlgorithm = new EvolutionaryAlgorithm<PermutationSolution<Integer>>("GGA", createInitialPopulation, evaluation, (Termination)termination, selection, variation, replacement){

            @Override
            public void updateProgress() {
                PermutationSolution bestFitnessSolution = (PermutationSolution)this.population().stream().min(new MultiComparator(List.of(new OverallConstraintViolationDegreeComparator(), new ObjectiveComparator(0)))).get();
                this.attributes().put("BEST_SOLUTION", bestFitnessSolution);
                super.updateProgress();
            }
        };
        FitnessPlotObserver chartObserver = new FitnessPlotObserver("Genetic algorithm", "Evaluations", "Fitness", "fitness", 10000);
        geneticAlgorithm.observable().register((Observer)chartObserver);
        geneticAlgorithm.run();
        Object population = geneticAlgorithm.result();
        JMetalLogger.logger.info("Total execution time : " + geneticAlgorithm.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + geneticAlgorithm.numberOfEvaluations());
        JMetalLogger.logger.info("Best found solution: " + ((PermutationSolution)population.get(0)).objectives()[0]);
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
    }
}

