/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.examples.singleobjective.randomsearch;

import java.util.List;
import org.uma.jmetal.component.algorithm.RandomSearchAlgorithm;
import org.uma.jmetal.component.catalogue.common.evaluation.impl.SequentialEvaluation;
import org.uma.jmetal.component.catalogue.common.solutionscreation.impl.RandomSolutionsCreation;
import org.uma.jmetal.component.catalogue.common.termination.impl.TerminationByEvaluations;
import org.uma.jmetal.problem.singleobjective.OneMax;
import org.uma.jmetal.solution.binarysolution.BinarySolution;
import org.uma.jmetal.util.AbstractAlgorithmRunner;
import org.uma.jmetal.util.JMetalLogger;
import org.uma.jmetal.util.errorchecking.JMetalException;
import org.uma.jmetal.util.fileoutput.FileOutputContext;
import org.uma.jmetal.util.fileoutput.SolutionListOutput;
import org.uma.jmetal.util.fileoutput.impl.DefaultFileOutputContext;
import org.uma.jmetal.util.observer.Observer;
import org.uma.jmetal.util.observer.impl.EvaluationObserver;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class RandomSearchSingleObjectiveBinaryEncodingExample
extends AbstractAlgorithmRunner {
    public static void main(String[] args) throws JMetalException {
        OneMax problem = new OneMax(Integer.valueOf(512));
        TerminationByEvaluations termination = new TerminationByEvaluations(50000);
        SequentialEvaluation evaluation = new SequentialEvaluation(problem);
        RandomSolutionsCreation solutionsCreation = new RandomSolutionsCreation(problem, 1);
        RandomSearchAlgorithm algorithm = new RandomSearchAlgorithm("Random Search", solutionsCreation, evaluation, termination);
        EvaluationObserver evaluationObserver = new EvaluationObserver(Integer.valueOf(1000));
        algorithm.getObservable().register((Observer)evaluationObserver);
        algorithm.run();
        Object population = algorithm.result();
        JMetalLogger.logger.info("Total execution time : " + algorithm.totalComputingTime() + "ms");
        JMetalLogger.logger.info("Number of evaluations: " + algorithm.evaluations());
        new SolutionListOutput((List)population).setVarFileOutputContext((FileOutputContext)new DefaultFileOutputContext("VAR.csv", ",")).setFunFileOutputContext((FileOutputContext)new DefaultFileOutputContext("FUN.csv", ",")).print();
        JMetalLogger.logger.info("Random seed: " + JMetalRandom.getInstance().getSeed());
        JMetalLogger.logger.info("Objectives values have been written to file FUN.csv");
        JMetalLogger.logger.info("Variables values have been written to file VAR.csv");
        JMetalLogger.logger.info("Best found solution: " + ((BinarySolution)population.get(0)).objectives()[0]);
    }
}

