/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.component.util;

import java.util.Comparator;
import java.util.List;
import org.uma.jmetal.util.comparator.MultiComparator;
import org.uma.jmetal.util.densityestimator.DensityEstimator;
import org.uma.jmetal.util.ranking.Ranking;

public class RankingAndDensityEstimatorPreference<S> {
    private Ranking<S> ranking;
    private DensityEstimator<S> densityEstimator;
    private RankingAndDensityEstimatorPreference<S> relatedPreference;
    private boolean preferenceHasBeenComputedFirstTime = false;

    public RankingAndDensityEstimatorPreference(Ranking<S> ranking, DensityEstimator<S> densityEstimator) {
        this(ranking, densityEstimator, null);
    }

    public RankingAndDensityEstimatorPreference(Ranking<S> ranking, DensityEstimator<S> densityEstimator, RankingAndDensityEstimatorPreference<S> relatedPreference) {
        this.ranking = ranking;
        this.densityEstimator = densityEstimator;
        this.relatedPreference = relatedPreference;
    }

    public void recompute(List<S> solutionList) {
        if (!this.preferenceHasBeenComputedFirstTime) {
            this.recomputeRanking(solutionList);
            this.recomputeDensityEstimator();
            this.preferenceHasBeenComputedFirstTime = true;
        } else if (this.relatedPreference != null) {
            if (this.rankingsAreDifferent()) {
                this.recomputeRanking(solutionList);
                this.recomputeDensityEstimator();
            } else if (this.densityEstimatorsAreDifferent()) {
                this.recomputeDensityEstimator();
            }
        }
    }

    private boolean densityEstimatorsAreDifferent() {
        return this.densityEstimator.getClass() != this.relatedPreference.getDensityEstimator().getClass();
    }

    private void recomputeDensityEstimator() {
        for (int i = 0; i < this.ranking.getNumberOfSubFronts(); ++i) {
            this.densityEstimator.compute(this.ranking.getSubFront(i));
        }
    }

    private void recomputeRanking(List<S> solutionList) {
        this.ranking.compute(solutionList);
    }

    private boolean rankingsAreDifferent() {
        return !this.ranking.getClass().equals(this.relatedPreference.getRanking().getClass());
    }

    public Ranking<S> getRanking() {
        return this.ranking;
    }

    public DensityEstimator<S> getDensityEstimator() {
        return this.densityEstimator;
    }

    public Comparator<S> getComparator() {
        return new MultiComparator(List.of(Comparator.comparing(arg_0 -> this.getRanking().getRank(arg_0)), Comparator.comparing(arg_0 -> this.getDensityEstimator().value(arg_0)).reversed()));
    }
}

