/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.IntegerSolution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class IntegerPolynomialMutation
implements MutationOperator<IntegerSolution> {
    private static final double ETA_M_DEFAULT = 20.0;
    private double distributionIndex;
    private double mutationProbability;
    private JMetalRandom randomGenerator;

    public IntegerPolynomialMutation(double mutationProbability, double distributionIndex) {
        this.mutationProbability = mutationProbability;
        this.distributionIndex = distributionIndex;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    @Override
    public IntegerSolution execute(IntegerSolution solution) throws JMetalException {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, IntegerSolution solution) throws JMetalException {
        this.doRealMutation(probability, solution);
    }

    private void doRealMutation(double probability, IntegerSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            Double deltaq;
            Double val;
            Double xy;
            if (!(this.randomGenerator.nextDouble() <= probability)) continue;
            Double y = (double)((Integer)solution.getVariableValue(i));
            Double yl = (double)solution.getLowerBound(i);
            Double yu = (double)solution.getUpperBound(i);
            Double delta1 = (y - yl) / (yu - yl);
            Double delta2 = (yu - y) / (yu - yl);
            Double rnd = this.randomGenerator.nextDouble();
            Double mutPow = 1.0 / (this.distributionIndex + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex + 1.0);
                deltaq = Math.pow(val, mutPow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex + 1.0);
                deltaq = 1.0 - Math.pow(val, mutPow);
            }
            y = y + deltaq * (yu - yl);
            if (y < yl) {
                y = yl;
            }
            if (y > yu) {
                y = yu;
            }
            solution.setVariableValue(i, y.intValue());
        }
    }
}

