/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.mutation;

import org.uma.jmetal.operator.MutationOperator;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.util.RepairDoubleSolution;
import org.uma.jmetal.solution.util.RepairDoubleSolutionAtBounds;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class PolynomialMutation
implements MutationOperator<DoubleSolution> {
    private double distributionIndex;
    private double mutationProbability;
    private RepairDoubleSolution solutionRepair;
    private JMetalRandom randomGenerator;

    public PolynomialMutation(double mutationProbability, double distributionIndex) {
        this(mutationProbability, distributionIndex, new RepairDoubleSolutionAtBounds());
    }

    public PolynomialMutation(double mutationProbability, double distributionIndex, RepairDoubleSolution solutionRepair) {
        if (mutationProbability < 0.0) {
            throw new JMetalException("Mutation probability is negative: " + mutationProbability);
        }
        if (distributionIndex < 0.0) {
            throw new JMetalException("Distribution index is negative: " + distributionIndex);
        }
        this.mutationProbability = mutationProbability;
        this.distributionIndex = distributionIndex;
        this.solutionRepair = solutionRepair;
        this.randomGenerator = JMetalRandom.getInstance();
    }

    public double getMutationProbability() {
        return this.mutationProbability;
    }

    public double getDistributionIndex() {
        return this.distributionIndex;
    }

    @Override
    public DoubleSolution execute(DoubleSolution solution) throws JMetalException {
        if (null == solution) {
            throw new JMetalException("Null parameter");
        }
        this.doMutation(this.mutationProbability, solution);
        return solution;
    }

    public void doMutation(double probability, DoubleSolution solution) throws JMetalException {
        this.doRealMutation(probability, solution);
    }

    private void doRealMutation(double probability, DoubleSolution solution) {
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            double deltaq;
            double val;
            double xy;
            if (!(this.randomGenerator.nextDouble() <= probability)) continue;
            double y = (Double)solution.getVariableValue(i);
            double yl = solution.getLowerBound(i);
            double yu = solution.getUpperBound(i);
            double delta1 = (y - yl) / (yu - yl);
            double delta2 = (yu - y) / (yu - yl);
            double rnd = this.randomGenerator.nextDouble();
            double mutPow = 1.0 / (this.distributionIndex + 1.0);
            if (rnd <= 0.5) {
                xy = 1.0 - delta1;
                val = 2.0 * rnd + (1.0 - 2.0 * rnd) * Math.pow(xy, this.distributionIndex + 1.0);
                deltaq = Math.pow(val, mutPow) - 1.0;
            } else {
                xy = 1.0 - delta2;
                val = 2.0 * (1.0 - rnd) + 2.0 * (rnd - 0.5) * Math.pow(xy, this.distributionIndex + 1.0);
                deltaq = 1.0 - Math.pow(val, mutPow);
            }
            y += deltaq * (yu - yl);
            y = this.solutionRepair.repairSolutionVariableValue(y, yl, yu);
            solution.setVariableValue(i, y);
        }
    }
}

