/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.operator.impl.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.comparator.CrowdingDistanceComparator;
import org.uma.jmetal.util.solutionattribute.Ranking;
import org.uma.jmetal.util.solutionattribute.impl.CrowdingDistance;
import org.uma.jmetal.util.solutionattribute.impl.DominanceRanking;

public class RankingAndCrowdingSelection
implements SelectionOperator<List<? extends Solution>, List<? extends Solution>> {
    private int solutionsToSelect = 0;

    public RankingAndCrowdingSelection(int solutionsToSelect) {
        this.solutionsToSelect = solutionsToSelect;
    }

    public int getSolutionsToSelect() {
        return this.solutionsToSelect;
    }

    @Override
    public List<? extends Solution> execute(List<? extends Solution> solutionList) throws JMetalException {
        if (null == solutionList) {
            throw new JMetalException("The solution list is null");
        }
        if (solutionList.isEmpty()) {
            throw new JMetalException("The solution list is empty");
        }
        if (solutionList.size() < this.solutionsToSelect) {
            throw new JMetalException("The population size (" + solutionList.size() + ") is smaller than" + "the solutions to selected (" + this.solutionsToSelect + ")");
        }
        DominanceRanking ranking = new DominanceRanking();
        ranking.computeRanking(solutionList);
        List<Solution> resultPopulation = this.crowdingDistanceSelection(ranking);
        return resultPopulation;
    }

    protected List<Solution> crowdingDistanceSelection(Ranking ranking) {
        CrowdingDistance crowdingDistance = new CrowdingDistance();
        ArrayList<Solution> population = new ArrayList<Solution>(this.solutionsToSelect);
        int rankingIndex = 0;
        while (population.size() < this.solutionsToSelect) {
            if (this.subfrontFillsIntoThePopulation(ranking, rankingIndex, population)) {
                this.addRankedSolutionsToPopulation(ranking, rankingIndex, population);
                ++rankingIndex;
                continue;
            }
            crowdingDistance.computeDensityEstimator(ranking.getSubfront(rankingIndex));
            this.addLastRankedSolutionsToPopulation(ranking, rankingIndex, population);
        }
        return population;
    }

    protected boolean subfrontFillsIntoThePopulation(Ranking ranking, int rank, List<Solution> population) {
        return ranking.getSubfront(rank).size() < this.solutionsToSelect - population.size();
    }

    protected void addRankedSolutionsToPopulation(Ranking ranking, int rank, List<Solution> population) {
        List front = ranking.getSubfront(rank);
        for (int i = 0; i < front.size(); ++i) {
            population.add((Solution)front.get(i));
        }
    }

    protected void addLastRankedSolutionsToPopulation(Ranking ranking, int rank, List<Solution> population) {
        List currentRankedFront = ranking.getSubfront(rank);
        Collections.sort(currentRankedFront, new CrowdingDistanceComparator());
        int i = 0;
        while (population.size() < this.solutionsToSelect) {
            population.add((Solution)currentRankedFront.get(i));
            ++i;
        }
    }
}

