/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.imp.FrontUtils;

public class Hypervolume
implements QualityIndicator {
    private static final String NAME = "HV";

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.hypervolume(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public double execute(List<? extends Solution> paretoFrontApproximation, List<? extends Solution> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.hypervolume(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    @Override
    public String getName() {
        return NAME;
    }

    boolean dominates(double[] point1, double[] point2, int noObjectives) {
        int i;
        int betterInAnyObjective = 0;
        for (i = 0; i < noObjectives && point1[i] >= point2[i]; ++i) {
            if (!(point1[i] > point2[i])) continue;
            betterInAnyObjective = 1;
        }
        return i >= noObjectives && betterInAnyObjective > 0;
    }

    void swap(double[][] front, int i, int j) {
        double[] temp = front[i];
        front[i] = front[j];
        front[j] = temp;
    }

    int filterNondominatedSet(double[][] front, int noPoints, int noObjectives) {
        int n = noPoints;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (this.dominates(front[i], front[j], noObjectives)) {
                    this.swap(front, j, --n);
                    continue;
                }
                if (this.dominates(front[j], front[i], noObjectives)) {
                    this.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    double surfaceUnchangedTo(double[][] front, int noPoints, int objective) {
        if (noPoints < 1) {
            new JMetalException("run-time error");
        }
        double minValue = front[0][objective];
        for (int i = 1; i < noPoints; ++i) {
            double value = front[i][objective];
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    int reduceNondominatedSet(double[][] front, int noPoints, int objective, double threshold) {
        int n = noPoints;
        for (int i = 0; i < n; ++i) {
            if (!(front[i][objective] <= threshold)) continue;
            this.swap(front, i, --n);
        }
        return n;
    }

    public double calculateHypervolume(double[][] front, int noPoints, int noObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = noPoints;
        while (n > 0) {
            double tempVolume;
            int nonDominatedPoints = this.filterNondominatedSet(front, n, noObjectives - 1);
            if (noObjectives < 3) {
                if (nonDominatedPoints < 1) {
                    new JMetalException("run-time error");
                }
                tempVolume = front[0][0];
            } else {
                tempVolume = this.calculateHypervolume(front, nonDominatedPoints, noObjectives - 1);
            }
            double tempDistance = this.surfaceUnchangedTo(front, n, noObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = this.reduceNondominatedSet(front, n, noObjectives - 1, distance);
        }
        return volume;
    }

    public double hypervolume(Front front, Front trueParetoFront) {
        int numberOfObjectives = trueParetoFront.getPoint(0).getNumberOfDimensions();
        double[] maximumValues = FrontUtils.getMaximumValues(trueParetoFront);
        double[] minimumValues = FrontUtils.getMinimumValues(trueParetoFront);
        Front normalizedFront = FrontUtils.getNormalizedFront(front, maximumValues, minimumValues);
        Front invertedFront = FrontUtils.getInvertedFront(normalizedFront);
        return this.calculateHypervolume(FrontUtils.convertFrontToArray(invertedFront), invertedFront.getNumberOfPoints(), numberOfObjectives);
    }
}

