/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.qualityindicator.impl;

import java.util.List;
import org.uma.jmetal.qualityindicator.QualityIndicator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.JMetalException;
import org.uma.jmetal.util.front.Front;
import org.uma.jmetal.util.front.imp.ArrayFront;
import org.uma.jmetal.util.front.imp.FrontUtils;
import org.uma.jmetal.util.point.impl.LexicographicalPointComparator;
import org.uma.jmetal.util.point.impl.PointUtils;

public class Spread
implements QualityIndicator {
    private static final String NAME = "SPREAD";

    @Override
    public double execute(Front paretoFrontApproximation, Front trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.spread(paretoFrontApproximation, trueParetoFront);
    }

    @Override
    public double execute(List<? extends Solution> paretoFrontApproximation, List<? extends Solution> trueParetoFront) {
        if (paretoFrontApproximation == null) {
            throw new JMetalException("The pareto front approximation object is null");
        }
        if (trueParetoFront == null) {
            throw new JMetalException("The pareto front object is null");
        }
        return this.execute(new ArrayFront(paretoFrontApproximation), new ArrayFront(trueParetoFront));
    }

    public double spread(Front front, Front trueParetoFront) {
        int i;
        double[] maximumValue = FrontUtils.getMaximumValues(trueParetoFront);
        double[] minimumValue = FrontUtils.getMinimumValues(trueParetoFront);
        Front normalizedFront = FrontUtils.getNormalizedFront(front, maximumValue, minimumValue);
        Front normalizedParetoFront = FrontUtils.getNormalizedFront(trueParetoFront, maximumValue, minimumValue);
        normalizedFront.sort(new LexicographicalPointComparator());
        normalizedParetoFront.sort(new LexicographicalPointComparator());
        double df = PointUtils.euclideanDistance(normalizedFront.getPoint(0), normalizedParetoFront.getPoint(0));
        double dl = PointUtils.euclideanDistance(normalizedFront.getPoint(normalizedFront.getNumberOfPoints() - 1), normalizedParetoFront.getPoint(normalizedParetoFront.getNumberOfPoints() - 1));
        double mean = 0.0;
        double diversitySum = df + dl;
        int numberOfPoints = normalizedFront.getNumberOfPoints();
        for (i = 0; i < numberOfPoints - 1; ++i) {
            mean += PointUtils.euclideanDistance(normalizedFront.getPoint(i), normalizedFront.getPoint(i + 1));
        }
        mean /= (double)(numberOfPoints - 1);
        if (numberOfPoints > 1) {
            for (i = 0; i < numberOfPoints - 1; ++i) {
                diversitySum += Math.abs(PointUtils.euclideanDistance(normalizedFront.getPoint(i), normalizedFront.getPoint(i + 1)) - mean);
            }
            return diversitySum / (df + dl + (double)(numberOfPoints - 1) * mean);
        }
        return 1.0;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

