/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.uma.jmetal.problem.Problem;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public abstract class AbstractGenericSolution<T, P extends Problem>
implements Solution<T> {
    protected List<Double> objectives;
    protected List<T> variables;
    protected P problem;
    protected double overallConstraintViolationDegree;
    protected int numberOfViolatedConstraints;
    protected Map<Object, Object> attributes = new HashMap<Object, Object>();
    protected final JMetalRandom randomGenerator = JMetalRandom.getInstance();

    protected AbstractGenericSolution() {
    }

    @Override
    public void setAttribute(Object id, Object value) {
        this.attributes.put(id, value);
    }

    @Override
    public Object getAttribute(Object id) {
        return this.attributes.get(id);
    }

    @Override
    public void setObjective(int index, double value) {
        this.objectives.set(index, value);
    }

    @Override
    public double getObjective(int index) {
        return this.objectives.get(index);
    }

    @Override
    public T getVariableValue(int index) {
        return this.variables.get(index);
    }

    @Override
    public void setVariableValue(int index, T value) {
        this.variables.set(index, value);
    }

    @Override
    public int getNumberOfVariables() {
        return this.variables.size();
    }

    @Override
    public int getNumberOfObjectives() {
        return this.objectives.size();
    }

    @Override
    public double getOverallConstraintViolationDegree() {
        return this.overallConstraintViolationDegree;
    }

    @Override
    public void setOverallConstraintViolationDegree(double violationDegree) {
        this.overallConstraintViolationDegree = violationDegree;
    }

    @Override
    public int getNumberOfViolatedConstraints() {
        return this.numberOfViolatedConstraints;
    }

    @Override
    public void setNumberOfViolatedConstraints(int numberOfViolatedConstraints) {
        this.numberOfViolatedConstraints = numberOfViolatedConstraints;
    }

    protected void initializeObjectiveValues() {
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.objectives.add(new Double(0.0));
        }
    }

    public String toString() {
        String result = "Variables: ";
        for (T var : this.variables) {
            result = result + "" + var + " ";
        }
        result = result + "Objectives: ";
        for (Double obj : this.objectives) {
            result = result + "" + obj + " ";
        }
        result = result + "\t";
        result = result + "AlgorithmAttributes: " + this.attributes + "\n";
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractGenericSolution)) {
            return false;
        }
        AbstractGenericSolution that = (AbstractGenericSolution)o;
        if (Double.compare(that.overallConstraintViolationDegree, this.overallConstraintViolationDegree) != 0) {
            return false;
        }
        if (this.attributes != null ? !this.attributes.equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.objectives != null ? !this.objectives.equals(that.objectives) : that.objectives != null) {
            return false;
        }
        return !(this.variables != null ? !this.variables.equals(that.variables) : that.variables != null);
    }

    public int hashCode() {
        int result = this.objectives != null ? this.objectives.hashCode() : 0;
        result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.overallConstraintViolationDegree);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.attributes != null ? this.attributes.hashCode() : 0);
        return result;
    }
}

