/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.uma.jmetal.problem.BinaryProblem;
import org.uma.jmetal.solution.BinarySolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;
import org.uma.jmetal.util.binarySet.BinarySet;

public class GenericBinarySolution
extends AbstractGenericSolution<BinarySet, BinaryProblem>
implements BinarySolution {
    public GenericBinarySolution(BinaryProblem problem) {
        int i;
        this.problem = problem;
        this.objectives = new ArrayList(problem.getNumberOfObjectives());
        this.variables = new ArrayList(problem.getNumberOfVariables());
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < problem.getNumberOfVariables(); ++i) {
            this.variables.add(this.createNewBitSet(problem.getNumberOfBits(i)));
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.objectives.add(0.0);
        }
    }

    public GenericBinarySolution(GenericBinarySolution solution) {
        this.problem = solution.problem;
        this.objectives = new ArrayList();
        for (int i = 0; i < ((BinaryProblem)this.problem).getNumberOfObjectives(); ++i) {
            this.objectives.add(solution.getObjective(i));
        }
        this.variables = new ArrayList();
        for (BinarySet var : solution.variables) {
            this.variables.add((BinarySet)var.clone());
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    private BinarySet createNewBitSet(int numberOfBits) {
        BinarySet bitSet = new BinarySet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            double rnd = this.randomGenerator.nextDouble();
            if (rnd < 0.5) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    @Override
    public int getNumberOfBits(int index) {
        return ((BinarySet)this.variables.get(index)).getBinarySetLength();
    }

    @Override
    public Solution copy() {
        return new GenericBinarySolution(this);
    }

    @Override
    public int getTotalNumberOfBits() {
        int sum = 0;
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            sum += ((BinarySet)this.variables.get(i)).getBinarySetLength();
        }
        return sum;
    }

    @Override
    public String getVariableValueString(int index) {
        String result = "";
        for (int i = 0; i < ((BinarySet)this.variables.get(index)).getBinarySetLength(); ++i) {
            result = ((BinarySet)this.variables.get(index)).get(i) ? result + "1" : result + "0";
        }
        return result;
    }
}

