/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import org.uma.jmetal.problem.DoubleBinaryProblem;
import org.uma.jmetal.solution.DoubleBinarySolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericDoubleBinarySolution
extends AbstractGenericSolution<Object, DoubleBinaryProblem>
implements DoubleBinarySolution {
    private int numberOfDoubleVariables;

    public GenericDoubleBinarySolution(DoubleBinaryProblem problem) {
        this.problem = problem;
        this.objectives = new ArrayList(problem.getNumberOfObjectives());
        this.variables = new ArrayList(problem.getNumberOfVariables());
        this.numberOfDoubleVariables = problem.getNumberOfDoubleVariables();
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        this.initializeDoubleVariables();
        this.initializeBitSet();
        this.initializeObjectiveValues();
    }

    public GenericDoubleBinarySolution(GenericDoubleBinarySolution solution) {
        this.problem = solution.problem;
        this.objectives = new ArrayList();
        for (Double obj : solution.objectives) {
            this.objectives.add(new Double(obj));
        }
        this.copyDoubleVariables(solution);
        this.copyBitSet(solution);
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    private void initializeDoubleVariables() {
        for (int i = 0; i < this.numberOfDoubleVariables; ++i) {
            Double value = this.randomGenerator.nextDouble(this.getLowerBound(i), this.getUpperBound(i));
            this.variables.add(value);
        }
    }

    private void initializeBitSet() {
        BitSet bitset = this.createNewBitSet(((DoubleBinaryProblem)this.problem).getNumberOfBits());
        this.variables.add(bitset);
    }

    private void copyDoubleVariables(GenericDoubleBinarySolution solution) {
        this.variables = new ArrayList();
        for (int i = 0; i < this.numberOfDoubleVariables; ++i) {
            this.variables.add(new Double((Double)solution.getVariableValue(i)));
        }
    }

    private void copyBitSet(GenericDoubleBinarySolution solution) {
        BitSet bitset = (BitSet)solution.getVariableValue(solution.getNumberOfVariables() - 1);
        this.variables.add(bitset.clone());
    }

    @Override
    public int getNumberOfDoubleVariables() {
        return this.numberOfDoubleVariables;
    }

    @Override
    public Double getUpperBound(int index) {
        return (Double)((DoubleBinaryProblem)this.problem).getUpperBound(index);
    }

    @Override
    public int getNumberOfBits() {
        return ((DoubleBinaryProblem)this.problem).getNumberOfBits();
    }

    @Override
    public Double getLowerBound(int index) {
        return (Double)((DoubleBinaryProblem)this.problem).getLowerBound(index);
    }

    @Override
    public Solution copy() {
        return new GenericDoubleBinarySolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return this.variables.get(index).toString();
    }

    private BitSet createNewBitSet(int numberOfBits) {
        BitSet bitSet = new BitSet(numberOfBits);
        for (int i = 0; i < numberOfBits; ++i) {
            if (this.randomGenerator.nextDouble() < 0.5) {
                bitSet.set(i, true);
                continue;
            }
            bitSet.set(i, false);
        }
        return bitSet;
    }
}

