/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.uma.jmetal.problem.DoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericDoubleSolution
extends AbstractGenericSolution<Double, DoubleProblem>
implements DoubleSolution {
    public GenericDoubleSolution(DoubleProblem problem) {
        int i;
        this.problem = problem;
        this.objectives = new ArrayList(problem.getNumberOfObjectives());
        this.variables = new ArrayList(problem.getNumberOfVariables());
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < problem.getNumberOfVariables(); ++i) {
            Double value = this.randomGenerator.nextDouble() * (this.getUpperBound(i) - this.getLowerBound(i)) + this.getLowerBound(i);
            this.variables.add(value);
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.objectives.add(new Double(0.0));
        }
    }

    public GenericDoubleSolution(GenericDoubleSolution solution) {
        this.problem = solution.problem;
        this.objectives = new ArrayList();
        for (Double obj : solution.objectives) {
            this.objectives.add(new Double(obj));
        }
        this.variables = new ArrayList();
        for (Double var : solution.variables) {
            this.variables.add(new Double(var));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Double getUpperBound(int index) {
        return ((DoubleProblem)this.problem).getUpperBound(index);
    }

    @Override
    public Double getLowerBound(int index) {
        return ((DoubleProblem)this.problem).getLowerBound(index);
    }

    @Override
    public Solution copy() {
        return new GenericDoubleSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Double)this.variables.get(index)).toString();
    }
}

