/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.uma.jmetal.problem.IntegerDoubleProblem;
import org.uma.jmetal.solution.IntegerDoubleSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericIntegerDoubleSolution
extends AbstractGenericSolution<Number, IntegerDoubleProblem>
implements IntegerDoubleSolution {
    private int numberOfIntegerVariables;
    private int numberOfDoubleVariables;

    public GenericIntegerDoubleSolution(IntegerDoubleProblem problem) {
        Number value;
        int i;
        this.problem = problem;
        this.objectives = new ArrayList(problem.getNumberOfObjectives());
        this.variables = new ArrayList(problem.getNumberOfVariables());
        this.numberOfIntegerVariables = problem.getNumberOfIntegerVariables();
        this.numberOfDoubleVariables = problem.getNumberOfDoubleVariables();
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < this.numberOfIntegerVariables; ++i) {
            value = this.randomGenerator.nextInt((Integer)this.getLowerBound(i), (Integer)this.getUpperBound(i));
            this.variables.add(value);
        }
        for (i = this.numberOfIntegerVariables; i < this.getNumberOfVariables(); ++i) {
            value = this.randomGenerator.nextDouble((Double)this.getLowerBound(i), (Double)this.getUpperBound(i));
            this.variables.add(value);
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.objectives.add(new Double(0.0));
        }
    }

    public GenericIntegerDoubleSolution(GenericIntegerDoubleSolution solution) {
        int i;
        this.problem = solution.problem;
        this.objectives = new ArrayList();
        for (Double obj : solution.objectives) {
            this.objectives.add(new Double(obj));
        }
        this.variables = new ArrayList();
        for (i = 0; i < this.numberOfIntegerVariables; ++i) {
            this.variables.add(new Integer((Integer)solution.getVariableValue(i)));
        }
        this.variables = new ArrayList();
        for (i = this.numberOfIntegerVariables; i < this.numberOfIntegerVariables + this.numberOfDoubleVariables; ++i) {
            this.variables.add(new Double((Double)solution.getVariableValue(i)));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Number getUpperBound(int index) {
        return ((IntegerDoubleProblem)this.problem).getUpperBound(index);
    }

    @Override
    public int getNumberOfIntegerVariables() {
        return this.numberOfIntegerVariables;
    }

    @Override
    public int getNumberOfDoubleVariables() {
        return this.numberOfDoubleVariables;
    }

    @Override
    public Number getLowerBound(int index) {
        return ((IntegerDoubleProblem)this.problem).getLowerBound(index);
    }

    @Override
    public Solution copy() {
        return new GenericIntegerDoubleSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Number)this.variables.get(index)).toString();
    }
}

