/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.uma.jmetal.problem.PermutationProblem;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericIntegerPermutationSolution
extends AbstractGenericSolution<List<Integer>, PermutationProblem>
implements PermutationSolution<List<Integer>> {
    public GenericIntegerPermutationSolution(PermutationProblem problem) {
        this.problem = problem;
        this.objectives = new ArrayList(problem.getNumberOfObjectives());
        this.variables = new ArrayList(problem.getNumberOfVariables());
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (int i = 0; i < problem.getNumberOfVariables(); ++i) {
            ArrayList<Integer> randomSequence = new ArrayList<Integer>(problem.getPermutationLength(i));
            for (int j = 0; j < problem.getPermutationLength(i); ++j) {
                randomSequence.add(j);
            }
            Collections.shuffle(randomSequence);
            this.variables.set(i, randomSequence);
        }
    }

    public GenericIntegerPermutationSolution(GenericIntegerPermutationSolution solution) {
        this.problem = solution.problem;
        this.objectives = new ArrayList();
        for (Double obj : solution.objectives) {
            this.objectives.add(new Double(obj));
        }
        this.variables = new ArrayList();
        for (List var : solution.variables) {
            ArrayList list = new ArrayList();
            for (Integer element : var) {
                var.add(new Integer(element));
            }
            this.variables.add(list);
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Solution copy() {
        return new GenericIntegerPermutationSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        String result = "";
        for (Integer element : (List)this.variables.get(index)) {
            result = result + element + " ";
        }
        return ((List)this.variables.get(index)).toString();
    }
}

