/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.solution.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.uma.jmetal.problem.IntegerProblem;
import org.uma.jmetal.solution.IntegerSolution;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.solution.impl.AbstractGenericSolution;

public class GenericIntegerSolution
extends AbstractGenericSolution<Integer, IntegerProblem>
implements IntegerSolution {
    public GenericIntegerSolution(IntegerProblem problem) {
        int i;
        this.problem = problem;
        this.objectives = new ArrayList(problem.getNumberOfObjectives());
        this.variables = new ArrayList(problem.getNumberOfVariables());
        this.overallConstraintViolationDegree = 0.0;
        this.numberOfViolatedConstraints = 0;
        for (i = 0; i < problem.getNumberOfVariables(); ++i) {
            Integer value = this.randomGenerator.nextInt(this.getLowerBound(i), this.getUpperBound(i));
            this.variables.add(value);
        }
        for (i = 0; i < problem.getNumberOfObjectives(); ++i) {
            this.objectives.add(new Double(0.0));
        }
    }

    public GenericIntegerSolution(GenericIntegerSolution solution) {
        this.problem = solution.problem;
        this.objectives = new ArrayList();
        for (Double obj : solution.objectives) {
            this.objectives.add(new Double(obj));
        }
        this.variables = new ArrayList();
        for (Integer var : solution.variables) {
            this.variables.add(new Integer(var));
        }
        this.overallConstraintViolationDegree = solution.overallConstraintViolationDegree;
        this.numberOfViolatedConstraints = solution.numberOfViolatedConstraints;
        this.attributes = new HashMap(solution.attributes);
    }

    @Override
    public Integer getUpperBound(int index) {
        return ((IntegerProblem)this.problem).getUpperBound(index);
    }

    @Override
    public Integer getLowerBound(int index) {
        return ((IntegerProblem)this.problem).getLowerBound(index);
    }

    @Override
    public Solution copy() {
        return new GenericIntegerSolution(this);
    }

    @Override
    public String getVariableValueString(int index) {
        return ((Integer)this.variables.get(index)).toString();
    }
}

