/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util;

import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.pseudorandom.JMetalRandom;

public class AdaptiveGrid<T extends Solution> {
    private int bisections;
    private int numberOfObjectives;
    private int[] hypercubes;
    private double[] gridLowerLimits;
    private double[] gridUpperLimits;
    private double[] divisionSize;
    private int mostPopulatedHypercube;
    private int[] occupied;

    public AdaptiveGrid(int bisections, int objetives) {
        this.bisections = bisections;
        this.numberOfObjectives = objetives;
        this.gridLowerLimits = new double[this.numberOfObjectives];
        this.gridUpperLimits = new double[this.numberOfObjectives];
        this.divisionSize = new double[this.numberOfObjectives];
        this.hypercubes = new int[(int)Math.pow(2.0, this.bisections * this.numberOfObjectives)];
        for (int i = 0; i < this.hypercubes.length; ++i) {
            this.hypercubes[i] = 0;
        }
    }

    private void updateLimits(List<T> solutionList) {
        for (int obj = 0; obj < this.numberOfObjectives; ++obj) {
            this.gridLowerLimits[obj] = Double.MAX_VALUE;
            this.gridUpperLimits[obj] = Double.MIN_VALUE;
        }
        for (int ind = 0; ind < solutionList.size(); ++ind) {
            Solution tmpIndividual = (Solution)solutionList.get(ind);
            for (int obj = 0; obj < this.numberOfObjectives; ++obj) {
                if (tmpIndividual.getObjective(obj) < this.gridLowerLimits[obj]) {
                    this.gridLowerLimits[obj] = tmpIndividual.getObjective(obj);
                }
                if (!(tmpIndividual.getObjective(obj) > this.gridUpperLimits[obj])) continue;
                this.gridUpperLimits[obj] = tmpIndividual.getObjective(obj);
            }
        }
    }

    private void addSolutionSet(List<T> solutionList) {
        this.mostPopulatedHypercube = 0;
        for (int ind = 0; ind < solutionList.size(); ++ind) {
            int location;
            int n = location = this.location((Solution)solutionList.get(ind));
            this.hypercubes[n] = this.hypercubes[n] + 1;
            if (this.hypercubes[location] <= this.hypercubes[this.mostPopulatedHypercube]) continue;
            this.mostPopulatedHypercube = location;
        }
        this.calculateOccupied();
    }

    public void updateGrid(List<T> solutionList) {
        this.updateLimits(solutionList);
        for (int obj = 0; obj < this.numberOfObjectives; ++obj) {
            this.divisionSize[obj] = this.gridUpperLimits[obj] - this.gridLowerLimits[obj];
        }
        for (int i = 0; i < this.hypercubes.length; ++i) {
            this.hypercubes[i] = 0;
        }
        this.addSolutionSet(solutionList);
    }

    public void updateGrid(T solution, List<T> solutionSet) {
        int location = this.location(solution);
        if (location == -1) {
            int obj;
            this.updateLimits(solutionSet);
            for (obj = 0; obj < this.numberOfObjectives; ++obj) {
                if (solution.getObjective(obj) < this.gridLowerLimits[obj]) {
                    this.gridLowerLimits[obj] = solution.getObjective(obj);
                }
                if (!(solution.getObjective(obj) > this.gridUpperLimits[obj])) continue;
                this.gridUpperLimits[obj] = solution.getObjective(obj);
            }
            for (obj = 0; obj < this.numberOfObjectives; ++obj) {
                this.divisionSize[obj] = this.gridUpperLimits[obj] - this.gridLowerLimits[obj];
            }
            for (int i = 0; i < this.hypercubes.length; ++i) {
                this.hypercubes[i] = 0;
            }
            this.addSolutionSet(solutionSet);
        }
    }

    public int location(T solution) {
        int[] position = new int[this.numberOfObjectives];
        for (int obj = 0; obj < this.numberOfObjectives; ++obj) {
            if (solution.getObjective(obj) > this.gridUpperLimits[obj] || solution.getObjective(obj) < this.gridLowerLimits[obj]) {
                return -1;
            }
            if (solution.getObjective(obj) == this.gridLowerLimits[obj]) {
                position[obj] = 0;
                continue;
            }
            if (solution.getObjective(obj) == this.gridUpperLimits[obj]) {
                position[obj] = (int)Math.pow(2.0, this.bisections) - 1;
                continue;
            }
            double tmpSize = this.divisionSize[obj];
            double value = solution.getObjective(obj);
            double account = this.gridLowerLimits[obj];
            int ranges = (int)Math.pow(2.0, this.bisections);
            for (int b = 0; b < this.bisections; ++b) {
                tmpSize /= 2.0;
                ranges /= 2;
                if (!(value > account + tmpSize)) continue;
                int n = obj;
                position[n] = position[n] + ranges;
                account += tmpSize;
            }
        }
        int location = 0;
        for (int obj = 0; obj < this.numberOfObjectives; ++obj) {
            location = (int)((double)location + (double)position[obj] * Math.pow(2.0, obj * this.bisections));
        }
        return location;
    }

    public int getMostPopulatedHypercube() {
        return this.mostPopulatedHypercube;
    }

    public int getLocationDensity(int location) {
        return this.hypercubes[location];
    }

    public void removeSolution(int location) {
        int n = location;
        this.hypercubes[n] = this.hypercubes[n] - 1;
        if (location == this.mostPopulatedHypercube) {
            for (int i = 0; i < this.hypercubes.length; ++i) {
                if (this.hypercubes[i] <= this.hypercubes[this.mostPopulatedHypercube]) continue;
                this.mostPopulatedHypercube = i;
            }
        }
        if (this.hypercubes[location] == 0) {
            this.calculateOccupied();
        }
    }

    public void addSolution(int location) {
        int n = location;
        this.hypercubes[n] = this.hypercubes[n] + 1;
        if (this.hypercubes[location] > this.hypercubes[this.mostPopulatedHypercube]) {
            this.mostPopulatedHypercube = location;
        }
        if (this.hypercubes[location] == 1) {
            this.calculateOccupied();
        }
    }

    public int getBisections() {
        return this.bisections;
    }

    public String toString() {
        String result = "Grid\n";
        for (int obj = 0; obj < this.numberOfObjectives; ++obj) {
            result = result + "Objective " + obj + " " + this.gridLowerLimits[obj] + " " + this.gridUpperLimits[obj] + "\n";
        }
        return result;
    }

    public int rouletteWheel() {
        int hypercube;
        double inverseSum = 0.0;
        for (int hypercube2 : this.hypercubes) {
            if (hypercube2 <= 0) continue;
            inverseSum += 1.0 / (double)hypercube2;
        }
        double random = JMetalRandom.getInstance().nextDouble(0.0, inverseSum);
        double accumulatedSum = 0.0;
        for (hypercube = 0; hypercube < this.hypercubes.length; ++hypercube) {
            if (this.hypercubes[hypercube] > 0) {
                accumulatedSum += 1.0 / (double)this.hypercubes[hypercube];
            }
            if (!(accumulatedSum > random)) continue;
            return hypercube;
        }
        return hypercube;
    }

    public int calculateOccupied() {
        int total = 0;
        for (int hypercube : this.hypercubes) {
            if (hypercube <= 0) continue;
            ++total;
        }
        this.occupied = new int[total];
        int base = 0;
        for (int i = 0; i < this.hypercubes.length; ++i) {
            if (this.hypercubes[i] <= 0) continue;
            this.occupied[base] = i;
            ++base;
        }
        return total;
    }

    public int occupiedHypercubes() {
        return this.occupied.length;
    }

    public int randomOccupiedHypercube() {
        int rand = JMetalRandom.getInstance().nextInt(0, this.occupied.length - 1);
        return this.occupied[rand];
    }
}

