/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.util.archive.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.AdaptiveGrid;
import org.uma.jmetal.util.archive.BoundedArchive;
import org.uma.jmetal.util.comparator.DominanceComparator;

public class AdaptiveGridArchive<S extends Solution>
implements BoundedArchive<S> {
    private AdaptiveGrid<S> grid;
    private List<S> solutionList;
    private int maxSize;
    private Comparator<Solution> dominanceComparator;

    public AdaptiveGridArchive(int maxSize, int bisections, int objectives) {
        this.maxSize = maxSize;
        this.dominanceComparator = new DominanceComparator();
        this.grid = new AdaptiveGrid(bisections, objectives);
        this.solutionList = new ArrayList<S>(maxSize);
    }

    @Override
    public boolean add(S solution) {
        Iterator<S> iterator = this.solutionList.iterator();
        while (iterator.hasNext()) {
            Solution element = (Solution)iterator.next();
            int flag = this.dominanceComparator.compare((Solution)solution, element);
            if (flag == -1) {
                iterator.remove();
                int location = this.grid.location(element);
                if (this.grid.getLocationDensity(location) > 1) {
                    this.grid.removeSolution(location);
                    continue;
                }
                this.grid.updateGrid(this.solutionList);
                continue;
            }
            if (flag != 1) continue;
            return false;
        }
        if (this.solutionList.size() == 0) {
            this.solutionList.add(solution);
            this.grid.updateGrid(this.solutionList);
            return true;
        }
        if (this.solutionList.size() < this.maxSize) {
            this.grid.updateGrid(solution, this.solutionList);
            int location = this.grid.location(solution);
            this.grid.addSolution(location);
            this.solutionList.add(solution);
            return true;
        }
        this.grid.updateGrid(solution, this.solutionList);
        int location = this.grid.location(solution);
        if (location == this.grid.getMostPopulatedHypercube()) {
            return false;
        }
        iterator = this.solutionList.iterator();
        boolean removed = false;
        while (iterator.hasNext()) {
            Solution element;
            int location2;
            if (removed || (location2 = this.grid.location(element = (Solution)iterator.next())) != this.grid.getMostPopulatedHypercube()) continue;
            iterator.remove();
            this.grid.removeSolution(location2);
        }
        this.grid.addSolution(location);
        this.solutionList.add(solution);
        return true;
    }

    public AdaptiveGrid getGrid() {
        return this.grid;
    }

    @Override
    public List<S> getSolutionList() {
        return this.solutionList;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }
}

